/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class LightHslStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(LightHslStatus.class.getName());
    private static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 6;
    private static final int OP_CODE = 33400;
    private int mPresentHslLightness;
    private int mPresentHslHue;
    private int mPresentHslSaturation;
    private int mTransitionSteps;
    private int mTransitionResolution;

    public LightHslStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received light hsl status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentHslLightness = buffer.getShort() & 0xFFFF;
        this.mPresentHslHue = buffer.getShort() & 0xFFFF;
        this.mPresentHslSaturation = buffer.getShort() & 0xFFFF;
        LOG.info("Present lightness: " + this.mPresentHslLightness);
        LOG.info("Present hue: " + this.mPresentHslHue);
        LOG.info("Present saturation: " + this.mPresentHslSaturation);
        if (buffer.limit() > 6) {
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33400;
    }

    public final int getPresentLightness() {
        return this.mPresentHslLightness;
    }

    public final int getPresentSaturation() {
        return this.mPresentHslSaturation;
    }

    public final int getPresentHue() {
        return this.mPresentHslHue;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

