/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class LightCtlStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(LightCtlStatus.class.getName());
    private static final int LIGHT_CTL_STATUS_MANDATORY_LENGTH = 4;
    private static final int OP_CODE = 33376;
    private int mPresentCtlLightness;
    private int mPresentCtlTemperature;
    private Integer mTargetCtlLightness;
    private Integer mTargetCtlTemperature;
    private int mTransitionSteps;
    private int mTransitionResolution;

    public LightCtlStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received light ctl status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentCtlLightness = buffer.getShort() & 0xFFFF;
        this.mPresentCtlTemperature = buffer.getShort() & 0xFFFF;
        LOG.info("Present lightness: " + this.mPresentCtlLightness);
        LOG.info("Present temperature: " + this.mPresentCtlTemperature);
        if (buffer.limit() > 4) {
            this.mTargetCtlLightness = buffer.getShort() & 0xFFFF;
            this.mTargetCtlTemperature = buffer.getShort() & 0xFFFF;
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            LOG.info("Target lightness: " + this.mTargetCtlLightness);
            LOG.info("Target temperature: " + this.mTargetCtlTemperature);
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33376;
    }

    public final int getPresentLightness() {
        return this.mPresentCtlLightness;
    }

    public final Integer getTargetLightness() {
        return this.mTargetCtlLightness;
    }

    public final int getPresentTemperature() {
        return this.mPresentCtlTemperature;
    }

    public final Integer getTargetTemperature() {
        return this.mTargetCtlTemperature;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

