/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class GenericOnOffStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(GenericOnOffStatus.class.getName());
    private static final int OP_CODE = 33284;
    private static final int GENERIC_ON_OFF_STATE_ON = 1;
    private boolean mPresentOn;
    private Boolean mTargetOn;
    private int mRemainingTime;
    private int mTransitionSteps;
    private int mTransitionResolution;

    public GenericOnOffStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received generic on off status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mPresentOn = buffer.get() == 1;
        LOG.info("Present on: " + this.mPresentOn);
        if (buffer.limit() > 1) {
            this.mTargetOn = buffer.get() == 1;
            this.mRemainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = this.mRemainingTime & 0x3F;
            this.mTransitionResolution = this.mRemainingTime >> 6;
            LOG.info("Target on: " + this.mTargetOn);
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(this.mRemainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33284;
    }

    public final boolean getPresentState() {
        return this.mPresentOn;
    }

    public final Boolean getTargetState() {
        return this.mTargetOn;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

