/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class GenericOnOffSet
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(GenericOnOffSet.class.getName());
    private static final int OP_CODE = 33282;
    private static final int GENERIC_ON_OFF_SET_TRANSITION_PARAMS_LENGTH = 4;
    private static final int GENERIC_ON_OFF_SET_PARAMS_LENGTH = 2;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final boolean mState;
    private final int tId;

    public GenericOnOffSet(ApplicationKey appKey, boolean state, int tId) throws IllegalArgumentException {
        this(appKey, state, tId, null, null, null);
    }

    public GenericOnOffSet(ApplicationKey appKey, boolean state, int tId, Integer transitionSteps, Integer transitionResolution, Integer delay) {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.mState = state;
        this.tId = tId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33282;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        LOG.info("State: " + (this.mState ? "ON" : "OFF"));
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
        } else {
            LOG.info("Transition steps: " + this.mTransitionSteps);
            LOG.info("Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put((byte)(this.mState ? 1 : 0));
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

