/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.UUID;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

class GenericMessageState
extends MeshMessageState {
    UUID mLabel;

    GenericMessageState(int src, int dst, MeshMessage meshMessage, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, meshMessage, meshTransport, callbacks);
    }

    GenericMessageState(int src, int dst, UUID label, MeshMessage meshMessage, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(meshMessage, meshTransport, callbacks);
        this.mSrc = src;
        if (!MeshAddress.isAddressInRange(src)) {
            throw new IllegalArgumentException("Invalid address, a source address must be a valid 16-bit value!");
        }
        this.mDst = dst;
        if (!MeshAddress.isAddressInRange(dst)) {
            throw new IllegalArgumentException("Invalid address, a destination address must be a valid 16-bit value");
        }
        this.mLabel = label;
        this.createAccessMessage();
    }

    protected synchronized void createAccessMessage() {
        GenericMessage genericMessage = (GenericMessage)this.mMeshMessage;
        ApplicationKey key = genericMessage.getAppKey();
        int akf = genericMessage.getAkf();
        int aid = genericMessage.getAid();
        int aszmic = genericMessage.getAszmic();
        int opCode = genericMessage.getOpCode();
        byte[] parameters = genericMessage.getParameters();
        this.message = this.mMeshTransport.createMeshMessage(this.mSrc, this.mDst, this.mLabel, genericMessage.messageTtl, key, akf, aid, aszmic, opCode, parameters);
        genericMessage.setMessage(this.message);
    }

    @Override
    public synchronized MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.GENERIC_MESSAGE_STATE;
    }
}

