/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class GenericLevelStatus
extends GenericStatusMessage {
    public static final Logger LOG = Logger.getLogger(GenericLevelStatus.class.getName());
    private static final int GENERIC_LEVEL_STATUS_MANDATORY_LENGTH = 2;
    private static final int OP_CODE = 33288;
    private int mPresentLevel;
    private Integer mTargetLevel;
    private int mTransitionSteps;
    private int mTransitionResolution;

    public GenericLevelStatus(AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        LOG.info("Received generic level status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentLevel = buffer.getShort();
        LOG.info("Present level: " + this.mPresentLevel);
        if (buffer.limit() > 2) {
            this.mTargetLevel = buffer.getShort();
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            LOG.info("Target level: " + this.mTargetLevel);
            LOG.info("Remaining time, transition number of steps: " + this.mTransitionSteps);
            LOG.info("Remaining time, transition number of step resolution: " + this.mTransitionResolution);
            LOG.info("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime));
        }
    }

    @Override
    public int getOpCode() {
        return 33288;
    }

    public final int getPresentLevel() {
        return this.mPresentLevel;
    }

    public final Integer getTargetLevel() {
        return this.mTargetLevel;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }
}

