/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class GenericLevelSetUnacknowledged
extends GenericMessage {
    public static final Logger LOG = Logger.getLogger(GenericLevelSetUnacknowledged.class.getName());
    private static final int OP_CODE = 33287;
    private static final int GENERIC_LEVEL_SET_TRANSITION_PARAMS_LENGTH = 5;
    private static final int GENERIC_LEVEL_SET_PARAMS_LENGTH = 3;
    private final Integer mTransitionSteps;
    private final Integer mTransitionResolution;
    private final Integer mDelay;
    private final int mLevel;
    private final int tId;

    public GenericLevelSetUnacknowledged(ApplicationKey appKey, int level, int tId) throws IllegalArgumentException {
        this(appKey, null, null, null, level, tId);
    }

    public GenericLevelSetUnacknowledged(ApplicationKey appKey, Integer transitionSteps, Integer transitionResolution, Integer delay, int level, int tId) throws IllegalArgumentException {
        super(appKey);
        this.mTransitionSteps = transitionSteps;
        this.mTransitionResolution = transitionResolution;
        this.mDelay = delay;
        this.tId = tId;
        if (level < Short.MIN_VALUE || level > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Generic level value must be between -32768 to 32767");
        }
        this.mLevel = level;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33287;
    }

    @Override
    void assembleMessageParameters() {
        ByteBuffer paramsBuffer;
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        LOG.info("Level: " + this.mLevel);
        if (this.mTransitionSteps == null || this.mTransitionResolution == null || this.mDelay == null) {
            paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLevel);
            paramsBuffer.put((byte)this.tId);
        } else {
            LOG.info("Transition steps: " + this.mTransitionSteps);
            LOG.info("Transition step resolution: " + this.mTransitionResolution);
            paramsBuffer = ByteBuffer.allocate(5).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mLevel);
            paramsBuffer.put((byte)this.tId);
            paramsBuffer.put((byte)(this.mTransitionResolution << 6 | this.mTransitionSteps));
            int delay = this.mDelay;
            paramsBuffer.put((byte)delay);
        }
        this.mParameters = paramsBuffer.array();
    }
}

