/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.VendorModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public final class Element {
    int locationDescriptor;
    final Map<Integer, MeshModel> meshModels;
    int elementAddress;
    String name;

    public Element(int elementAddress, int locationDescriptor, Map<Integer, MeshModel> models) {
        this(elementAddress, locationDescriptor, models, "Element: " + MeshAddress.formatAddress(elementAddress, true));
    }

    Element(int elementAddress, int locationDescriptor, Map<Integer, MeshModel> models, String name) {
        this.elementAddress = elementAddress;
        this.locationDescriptor = locationDescriptor;
        this.meshModels = models;
        this.name = name;
    }

    Element(int locationDescriptor, Map<Integer, MeshModel> models) {
        this.locationDescriptor = locationDescriptor;
        this.meshModels = models;
    }

    private void sortModels(HashMap<Integer, MeshModel> unorderedElements) {
        Set<Integer> unorderedKeys = unorderedElements.keySet();
        ArrayList<Integer> orderedKeys = new ArrayList<Integer>(unorderedKeys);
        Collections.sort(orderedKeys);
        for (int key : orderedKeys) {
            this.meshModels.put(key, unorderedElements.get(key));
        }
    }

    public int getElementAddress() {
        return this.elementAddress;
    }

    void setElementAddress(int elementAddress) {
        this.elementAddress = elementAddress;
    }

    public int getLocationDescriptor() {
        return this.locationDescriptor;
    }

    void setLocationDescriptor(int locationDescriptor) {
        this.locationDescriptor = locationDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSigModelCount() {
        int count = 0;
        for (Map.Entry<Integer, MeshModel> modelEntry : this.meshModels.entrySet()) {
            if (!(modelEntry.getValue() instanceof SigModel)) continue;
            ++count;
        }
        return count;
    }

    public int getVendorModelCount() {
        int count = 0;
        for (Map.Entry<Integer, MeshModel> modelEntry : this.meshModels.entrySet()) {
            if (!(modelEntry.getValue() instanceof VendorModel)) continue;
            ++count;
        }
        return count;
    }

    public Map<Integer, MeshModel> getMeshModels() {
        return Collections.unmodifiableMap(this.meshModels);
    }
}

