/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.Group;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.control.BlockAcknowledgementMessage;
import org.openremote.agent.protocol.bluetooth.mesh.control.TransportControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.models.ConfigurationServerModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SceneServer;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigAppKeyAdd;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigAppKeyDelete;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigAppKeyList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigAppKeyStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigAppKeyUpdate;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigBeaconStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigCompositionDataStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigDefaultTtlStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigFriendStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigHeartbeatPublicationStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigHeartbeatSubscriptionStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigKeyRefreshPhaseStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigLowPowerNodePollTimeoutStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelAppBind;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelAppStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelPublicationGet;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelPublicationSet;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelPublicationStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelPublicationVirtualAddressSet;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionAdd;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionDelete;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionDeleteAll;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionOverwrite;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionVirtualAddressAdd;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionVirtualAddressDelete;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigModelSubscriptionVirtualAddressOverwrite;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetKeyAdd;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetKeyDelete;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetKeyList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetKeyStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetKeyUpdate;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNetworkTransmitStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNodeIdentityStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigNodeResetStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigProxyStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigRelayStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigSigModelAppList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigSigModelSubscriptionList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigVendorModelAppList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigVendorModelSubscriptionList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ControlMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericLevelStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericOnOffStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LightCtlStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LightHslStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.LightLightnessStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigAddAddressToFilter;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigFilterStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigRemoveAddressFromFilter;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigSetFilterType;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneDelete;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneRecall;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneRegisterStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.SceneStore;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageAcked;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageUnacked;
import org.openremote.agent.protocol.bluetooth.mesh.utils.AddressArray;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.NetworkTransmitSettings;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilter;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ProxyFilterType;
import org.openremote.agent.protocol.bluetooth.mesh.utils.RelaySettings;

class DefaultNoOperationMessageState
extends MeshMessageState {
    public static final Logger LOG = Logger.getLogger(DefaultNoOperationMessageState.class.getName());

    DefaultNoOperationMessageState(MeshMessage meshMessage, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) {
        super(meshMessage, meshTransport, callbacks);
    }

    @Override
    public synchronized MeshMessageState.MessageState getState() {
        return null;
    }

    synchronized void parseMeshPdu(NetworkKey key, ProvisionedMeshNode node, byte[] pdu, byte[] networkHeader, byte[] decryptedNetworkPayload, int ivIndex, byte[] sequenceNumber) {
        try {
            Message message = this.mMeshTransport.parseMeshMessage(key, node, pdu, networkHeader, decryptedNetworkPayload, ivIndex, sequenceNumber);
            if (message != null) {
                if (message instanceof AccessMessage) {
                    this.parseAccessMessage((AccessMessage)message);
                } else {
                    this.parseControlMessage((ControlMessage)message);
                }
            } else {
                LOG.info("Message reassembly may not be completed yet!");
            }
        }
        catch (ExtendedInvalidCipherTextException e) {
            LOG.severe("Decryption failed in " + e.getTag() + " : " + e.getMessage());
            this.mMeshStatusCallbacks.onMessageDecryptionFailed(e.getTag(), e.getMessage());
        }
    }

    private void parseAccessMessage(AccessMessage message) {
        ProvisionedMeshNode node = this.mInternalTransportCallbacks.getNode(message.getSrc());
        int opCodeLength = MeshParserUtils.getOpCodeLength(message.getAccessPdu()[0] & 0xFF);
        switch (opCodeLength) {
            case 1: {
                if (message.getOpCode() == 2) {
                    ConfigCompositionDataStatus status = new ConfigCompositionDataStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setCompositionData(status);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 94) {
                    MeshModel model;
                    SceneStatus sceneStatus = new SceneStatus(message);
                    if (sceneStatus.isSuccessful() && (model = this.getMeshModel(node, sceneStatus.getSrc(), 4611)) != null) {
                        SceneServer sceneServer = (SceneServer)model;
                        sceneServer.currentScene = sceneStatus.getCurrentScene();
                        sceneServer.targetScene = sceneStatus.getTargetScene();
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(sceneStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), sceneStatus);
                    break;
                }
                if (message.getOpCode() == 6) {
                    MeshModel model;
                    ConfigHeartbeatPublicationStatus status = new ConfigHeartbeatPublicationStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, status.getSrc(), 0)) != null) {
                        ((ConfigurationServerModel)model).setHeartbeatPublication(!MeshAddress.isValidUnassignedAddress(status.getHeartbeatPublication().getDst()) ? status.getHeartbeatPublication() : null);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                this.handleUnknownPdu(message);
                break;
            }
            case 2: {
                if (message.getOpCode() == 32782) {
                    ConfigDefaultTtlStatus status = new ConfigDefaultTtlStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setTtl(status.getTtl());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32836) {
                    ConfigNetKeyStatus status = new ConfigNetKeyStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigNetKeyAdd) {
                            node.setAddedNetKeyIndex(status.getNetKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigNetKeyUpdate) {
                            node.updateAddedNetKey(status.getNetKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigNetKeyDelete) {
                            node.removeAddedNetKeyIndex(status.getNetKeyIndex());
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32835) {
                    ConfigNetKeyList netKeyList = new ConfigNetKeyList(message);
                    if (!this.isReceivedViaProxyFilter(message) && netKeyList.isSuccessful()) {
                        node.updateNetKeyList(netKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(netKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), netKeyList);
                    break;
                }
                if (message.getOpCode() == 32771) {
                    ConfigAppKeyStatus status = new ConfigAppKeyStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigAppKeyAdd) {
                            node.setAddedAppKeyIndex(status.getAppKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigAppKeyUpdate) {
                            node.updateAddedAppKey(status.getAppKeyIndex());
                        } else if (this.mMeshMessage instanceof ConfigAppKeyDelete) {
                            node.removeAddedAppKeyIndex(status.getAppKeyIndex());
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32770) {
                    ConfigAppKeyList appKeyList = new ConfigAppKeyList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful()) {
                        node.updateAppKeyList(appKeyList.getNetKeyIndex(), appKeyList.getKeyIndexes(), this.mInternalTransportCallbacks.getApplicationKeys(appKeyList.getNetKeyIndex()));
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32830) {
                    ConfigModelAppStatus status = new ConfigModelAppStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        if (this.mMeshMessage instanceof ConfigModelAppBind) {
                            node.setAppKeyBindStatus(status);
                        } else {
                            node.setAppKeyUnbindStatus(status);
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32844) {
                    MeshModel model;
                    ConfigSigModelAppList appKeyList = new ConfigSigModelAppList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful() && (model = this.getMeshModel(node, appKeyList.getElementAddress(), appKeyList.getModelIdentifier())) != null) {
                        model.setBoundAppKeyIndexes(appKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32846) {
                    MeshModel model;
                    ConfigVendorModelAppList appKeyList = new ConfigVendorModelAppList(message);
                    if (!this.isReceivedViaProxyFilter(message) && appKeyList.isSuccessful() && (model = this.getMeshModel(node, appKeyList.getElementAddress(), appKeyList.getModelIdentifier())) != null) {
                        model.setBoundAppKeyIndexes(appKeyList.getKeyIndexes());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(appKeyList);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), appKeyList);
                    break;
                }
                if (message.getOpCode() == 32793) {
                    MeshModel model;
                    ConfigModelPublicationStatus status = new ConfigModelPublicationStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier())) != null) {
                        if (this.mMeshMessage instanceof ConfigModelPublicationGet) {
                            model.updatePublicationStatus(status);
                        } else if (this.mMeshMessage instanceof ConfigModelPublicationSet) {
                            model.setPublicationStatus(status, null);
                        } else if (this.mMeshMessage instanceof ConfigModelPublicationVirtualAddressSet) {
                            UUID labelUUID = ((ConfigModelPublicationVirtualAddressSet)this.mMeshMessage).getLabelUuid();
                            model.setPublicationStatus(status, labelUUID);
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32799) {
                    MeshModel model;
                    ConfigModelSubscriptionStatus status = new ConfigModelSubscriptionStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier())) != null) {
                        if (this.mMeshMessage instanceof ConfigModelSubscriptionAdd) {
                            model.addSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressAdd) {
                            model.addSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressAdd)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionOverwrite) {
                            model.overwriteSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressOverwrite) {
                            model.overwriteSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressOverwrite)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionDelete) {
                            model.removeSubscriptionAddress(status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionVirtualAddressDelete) {
                            model.removeSubscriptionAddress(((ConfigModelSubscriptionVirtualAddressDelete)this.mMeshMessage).getLabelUuid(), status.getSubscriptionAddress());
                        } else if (this.mMeshMessage instanceof ConfigModelSubscriptionDeleteAll) {
                            model.removeAllSubscriptionAddresses();
                        }
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32810) {
                    ConfigSigModelSubscriptionList status = new ConfigSigModelSubscriptionList(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        MeshModel model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier());
                        if (model != null) {
                            model.updateSubscriptionAddressesList(status.getSubscriptionAddresses());
                        }
                        this.createGroups(status.getSubscriptionAddresses());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32812) {
                    ConfigVendorModelSubscriptionList status = new ConfigVendorModelSubscriptionList(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful()) {
                        MeshModel model = this.getMeshModel(node, status.getElementAddress(), status.getModelIdentifier());
                        if (model != null) {
                            model.updateSubscriptionAddressesList(status.getSubscriptionAddresses());
                        }
                        this.createGroups(status.getSubscriptionAddresses());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32828) {
                    MeshModel model;
                    ConfigHeartbeatSubscriptionStatus status = new ConfigHeartbeatSubscriptionStatus(message);
                    if (!this.isReceivedViaProxyFilter(message) && status.isSuccessful() && (model = this.getMeshModel(node, message.getSrc(), 0)) != null) {
                        ((ConfigurationServerModel)model).setHeartbeatSubscription(!MeshAddress.isValidUnassignedAddress(status.getHeartbeatSubscription().getSrc()) || !MeshAddress.isValidUnassignedAddress(status.getHeartbeatSubscription().getDst()) ? status.getHeartbeatSubscription() : null);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32840) {
                    ConfigNodeIdentityStatus status = new ConfigNodeIdentityStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.nodeIdentityState = status.getNodeIdentityState();
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32842) {
                    ConfigNodeResetStatus status = new ConfigNodeResetStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        this.mInternalTransportCallbacks.onMeshNodeReset(node);
                    }
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32805) {
                    ConfigNetworkTransmitStatus status = new ConfigNetworkTransmitStatus(message);
                    NetworkTransmitSettings networkTransmitSettings = new NetworkTransmitSettings(status.getNetworkTransmitCount(), status.getNetworkTransmitIntervalSteps());
                    node.setNetworkTransmitSettings(networkTransmitSettings);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32808) {
                    ConfigRelayStatus status = new ConfigRelayStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        RelaySettings relaySettings = new RelaySettings(status.getRelayRetransmitCount(), status.getRelayRetransmitIntervalSteps());
                        node.setRelaySettings(relaySettings);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32779) {
                    ConfigBeaconStatus status = new ConfigBeaconStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.setSecureNetworkBeaconSupported(status.isEnable());
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32785) {
                    ConfigFriendStatus status = new ConfigFriendStatus(message);
                    if (!this.isReceivedViaProxyFilter(message)) {
                        node.getNodeFeatures().setFriend(status.isEnable() ? 1 : 0);
                    }
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32791) {
                    ConfigKeyRefreshPhaseStatus status = new ConfigKeyRefreshPhaseStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32788) {
                    ConfigProxyStatus status = new ConfigProxyStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 32814) {
                    ConfigLowPowerNodePollTimeoutStatus status = new ConfigLowPowerNodePollTimeoutStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33284) {
                    GenericOnOffStatus status = new GenericOnOffStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                if (message.getOpCode() == 33288) {
                    GenericLevelStatus genericLevelStatus = new GenericLevelStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(genericLevelStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), genericLevelStatus);
                    break;
                }
                if (message.getOpCode() == 33358) {
                    LightLightnessStatus lightLightnessStatus = new LightLightnessStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightLightnessStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightLightnessStatus);
                    break;
                }
                if (message.getOpCode() == 33376) {
                    LightCtlStatus lightCtlStatus = new LightCtlStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightCtlStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightCtlStatus);
                    break;
                }
                if (message.getOpCode() == 33400) {
                    LightHslStatus lightHslStatus = new LightHslStatus(message);
                    this.mInternalTransportCallbacks.updateMeshNetwork(lightHslStatus);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), lightHslStatus);
                    break;
                }
                if (message.getOpCode() == 33349) {
                    if (this.mMeshMessage instanceof SceneStore) {
                        SceneRegisterStatus status = new SceneRegisterStatus(message);
                        this.storeScene(node, status);
                        this.mInternalTransportCallbacks.updateMeshNetwork(status);
                        this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                        break;
                    }
                    if (this.mMeshMessage instanceof SceneRecall) {
                        SceneStatus status = new SceneStatus(message);
                        this.storeScene(node, status);
                        this.mInternalTransportCallbacks.updateMeshNetwork(status);
                        this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                        break;
                    }
                    if (!(this.mMeshMessage instanceof SceneDelete)) break;
                    SceneRegisterStatus status = new SceneRegisterStatus(message);
                    this.deleteScene(node, status);
                    this.mInternalTransportCallbacks.updateMeshNetwork(status);
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                this.handleUnknownPdu(message);
                break;
            }
            case 3: {
                if (this.mMeshMessage instanceof VendorModelMessageAcked) {
                    VendorModelMessageAcked vendorModelMessageAcked = (VendorModelMessageAcked)this.mMeshMessage;
                    VendorModelMessageStatus status = new VendorModelMessageStatus(message, vendorModelMessageAcked.getModelIdentifier());
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    LOG.info("Vendor model Access PDU Received: " + MeshParserUtils.bytesToHex(message.getAccessPdu(), false));
                    break;
                }
                if (this.mMeshMessage instanceof VendorModelMessageUnacked) {
                    VendorModelMessageUnacked vendorModelMessageUnacked = (VendorModelMessageUnacked)this.mMeshMessage;
                    VendorModelMessageStatus status = new VendorModelMessageStatus(message, vendorModelMessageUnacked.getModelIdentifier());
                    this.mMeshStatusCallbacks.onMeshMessageReceived(message.getSrc(), status);
                    break;
                }
                this.handleUnknownPdu(message);
            }
        }
    }

    private void handleUnknownPdu(AccessMessage message) {
        LOG.info("Unknown Access PDU Received: " + MeshParserUtils.bytesToHex(message.getAccessPdu(), false));
        this.mMeshStatusCallbacks.onUnknownPduReceived(message.getSrc(), message.getAccessPdu());
    }

    private void parseControlMessage(ControlMessage controlMessage) {
        int segmentCount = this.message.getNetworkLayerPdu().size();
        if (controlMessage.getPduType() == 0) {
            TransportControlMessage transportControlMessage = controlMessage.getTransportControlMessage();
            if (transportControlMessage.getState() == TransportControlMessage.TransportControlMessageState.LOWER_TRANSPORT_BLOCK_ACKNOWLEDGEMENT) {
                LOG.info("Acknowledgement payload: " + MeshParserUtils.bytesToHex(controlMessage.getTransportControlPdu(), false));
                ArrayList<Integer> retransmitPduIndexes = BlockAcknowledgementMessage.getSegmentsToBeRetransmitted(controlMessage.getTransportControlPdu(), segmentCount);
                this.mMeshStatusCallbacks.onBlockAcknowledgementReceived(controlMessage.getSrc(), controlMessage);
                this.executeResend(retransmitPduIndexes);
            } else {
                LOG.info("Unexpected control message received, ignoring message");
                this.mMeshStatusCallbacks.onUnknownPduReceived(controlMessage.getSrc(), controlMessage.getTransportControlPdu());
            }
        } else if (controlMessage.getPduType() == 2 && controlMessage.getOpCode() == 3) {
            ProxyConfigFilterStatus status = new ProxyConfigFilterStatus(controlMessage);
            if (this.mMeshMessage instanceof ProxyConfigSetFilterType) {
                ProxyFilter filter = new ProxyFilter(status.getFilterType());
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            } else if (this.mMeshMessage instanceof ProxyConfigAddAddressToFilter) {
                ProxyFilter filter = this.updateProxyFilter(this.mInternalTransportCallbacks.getProxyFilter(), status.getFilterType());
                ProxyConfigAddAddressToFilter addAddressToFilter = (ProxyConfigAddAddressToFilter)this.mMeshMessage;
                for (AddressArray addressArray : addAddressToFilter.getAddresses()) {
                    filter.addAddress(addressArray);
                }
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            } else if (this.mMeshMessage instanceof ProxyConfigRemoveAddressFromFilter) {
                ProxyFilter filter = this.updateProxyFilter(this.mInternalTransportCallbacks.getProxyFilter(), status.getFilterType());
                ProxyConfigRemoveAddressFromFilter removeAddressFromFilter = (ProxyConfigRemoveAddressFromFilter)this.mMeshMessage;
                for (AddressArray addressArray : removeAddressFromFilter.getAddresses()) {
                    filter.removeAddress(addressArray);
                }
                this.mInternalTransportCallbacks.setProxyFilter(filter);
                this.mInternalTransportCallbacks.updateMeshNetwork(status);
                this.mMeshStatusCallbacks.onMeshMessageReceived(controlMessage.getSrc(), status);
            }
        }
    }

    private ProxyFilter updateProxyFilter(ProxyFilter currentFilter, ProxyFilterType filterType) {
        if (currentFilter != null && currentFilter.getFilterType().getType() == filterType.getType()) {
            return currentFilter;
        }
        return new ProxyFilter(filterType);
    }

    private boolean isReceivedViaProxyFilter(Message message) {
        ProxyFilter filter = this.mInternalTransportCallbacks.getProxyFilter();
        if (filter != null) {
            if (filter.getFilterType().getType() == 0) {
                return this.filterAddressMatches(filter, message.getDst());
            }
            return !this.filterAddressMatches(filter, message.getDst());
        }
        return false;
    }

    private boolean filterAddressMatches(ProxyFilter filter, int dst) {
        for (AddressArray addressArray : filter.getAddresses()) {
            int address = MeshParserUtils.unsignedBytesToInt(addressArray.getAddress()[1], addressArray.getAddress()[0]);
            if (address != dst) continue;
            return true;
        }
        return false;
    }

    private void createGroups(List<Integer> subscriptionAddresses) {
        MeshNetwork network = this.mInternalTransportCallbacks.getMeshNetwork();
        for (Integer groupAddress : subscriptionAddresses) {
            Group group = network.getGroup(groupAddress);
            if (group != null) continue;
            group = new Group(groupAddress, network.getMeshUUID());
            group.setName("Unknown Group");
            network.getGroups().add(group);
        }
    }

    private MeshModel getMeshModel(ProvisionedMeshNode node, int src, int modelId) {
        Element element = node.getElements().get(src);
        if (element != null) {
            return element.getMeshModels().get(modelId);
        }
        return null;
    }

    private void storeScene(ProvisionedMeshNode node, SceneRegisterStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            this.mInternalTransportCallbacks.storeScene(status.getSrc(), status.getCurrentScene(), status.getSceneList());
            if (!sceneServer.sceneNumbers.contains(status.getCurrentScene())) {
                sceneServer.sceneNumbers.add(status.getCurrentScene());
            }
            sceneServer.currentScene = status.getCurrentScene();
        }
    }

    private void storeScene(ProvisionedMeshNode node, SceneStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            sceneServer.currentScene = status.getCurrentScene();
        }
    }

    private void deleteScene(ProvisionedMeshNode node, SceneRegisterStatus status) {
        SceneServer sceneServer;
        if (status.isSuccessful() && (sceneServer = (SceneServer)this.getMeshModel(node, status.getSrc(), 4611)) != null) {
            int deletedScene = ((SceneDelete)this.mMeshMessage).getSceneNumber();
            this.mInternalTransportCallbacks.deleteScene(status.getSrc(), deletedScene, status.getSceneList());
            if (sceneServer.sceneNumbers.contains(deletedScene)) {
                sceneServer.sceneNumbers.remove((Object)deletedScene);
            }
        }
    }
}

