/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;

public abstract class ConfigStatusMessage
extends MeshMessage {
    protected int mStatusCode;
    protected String mStatusCodeName;

    public ConfigStatusMessage(AccessMessage message) {
        this.mMessage = message;
    }

    abstract void parseStatusParameters();

    @Override
    public final int getAkf() {
        return this.mMessage.getAkf();
    }

    @Override
    public final int getAid() {
        return this.mMessage.getAid();
    }

    @Override
    public final byte[] getParameters() {
        return this.mParameters;
    }

    protected ArrayList<Integer> decode(int dataSize, int offset) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int size = dataSize - offset;
        if (size == 0) {
            return arrayList;
        }
        if (size == 2) {
            byte[] netKeyIndex = new byte[]{(byte)(this.mParameters[offset + 1] & 0xF), this.mParameters[offset]};
            int keyIndex = ConfigStatusMessage.encode(netKeyIndex);
            arrayList.add(keyIndex);
        } else {
            int firstKeyIndex = ConfigStatusMessage.encode(new byte[]{(byte)(this.mParameters[offset + 1] & 0xF), this.mParameters[offset]});
            int secondNetKeyIndex = ConfigStatusMessage.encode(new byte[]{(byte)((this.mParameters[offset + 2] & 0xF0) >> 4), (byte)(this.mParameters[offset + 2] << 4 | (this.mParameters[offset + 1] & 0xF0) >> 4)});
            arrayList.add(firstKeyIndex);
            arrayList.add(secondNetKeyIndex);
            arrayList.addAll(this.decode(dataSize, offset + 3));
        }
        return arrayList;
    }

    private static int encode(byte[] netKeyIndex) {
        return ByteBuffer.wrap(netKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public final int getStatusCode() {
        return this.mStatusCode;
    }

    public final String getStatusCodeName() {
        return this.mStatusCodeName;
    }

    final String getStatusCodeName(int statusCode) {
        switch (StatusCodeNames.fromStatusCode(statusCode)) {
            case SUCCESS: {
                return "Success";
            }
            case INVALID_ADDRESS: {
                return "Invalid Address";
            }
            case INVALID_MODEL: {
                return "Invalid Model";
            }
            case INVALID_APPKEY_INDEX: {
                return "Invalid ApplicationKey Index";
            }
            case INVALID_NETKEY_INDEX: {
                return "Invalid NetKey Index";
            }
            case INSUFFICIENT_RESOURCES: {
                return "Insufficient Resources";
            }
            case KEY_INDEX_ALREADY_STORED: {
                return "Key Index Already Stored";
            }
            case INVALID_PUBLISH_PARAMETERS: {
                return "Invalid Publish Parameters";
            }
            case NOT_A_SUBSCRIBE_MODEL: {
                return "Not a Subscribe Model";
            }
            case STORAGE_FAILURE: {
                return "Storage Failure";
            }
            case FEATURE_NOT_SUPPORTED: {
                return "Feature Not Supported";
            }
            case CANNOT_UPDATE: {
                return "Cannot Update";
            }
            case CANNOT_REMOVE: {
                return "Cannot Remove";
            }
            case CANNOT_BIND: {
                return "Cannot Bind";
            }
            case TEMPORARILY_UNABLE_TO_CHANGE_STATE: {
                return "Temporarily Unable to Change State";
            }
            case CANNOT_SET: {
                return "Cannot Set";
            }
            case UNSPECIFIED_ERROR: {
                return "Unspecified Error";
            }
            case INVALID_BINDING: {
                return "Invalid Binding";
            }
        }
        return "RFU";
    }

    public static enum StatusCodeNames {
        SUCCESS(0),
        INVALID_ADDRESS(1),
        INVALID_MODEL(2),
        INVALID_APPKEY_INDEX(3),
        INVALID_NETKEY_INDEX(4),
        INSUFFICIENT_RESOURCES(5),
        KEY_INDEX_ALREADY_STORED(6),
        INVALID_PUBLISH_PARAMETERS(7),
        NOT_A_SUBSCRIBE_MODEL(8),
        STORAGE_FAILURE(9),
        FEATURE_NOT_SUPPORTED(10),
        CANNOT_UPDATE(11),
        CANNOT_REMOVE(12),
        CANNOT_BIND(13),
        TEMPORARILY_UNABLE_TO_CHANGE_STATE(14),
        CANNOT_SET(15),
        UNSPECIFIED_ERROR(16),
        INVALID_BINDING(17),
        RFU(18);

        private final int statusCode;

        private StatusCodeNames(int statusCode) {
            this.statusCode = statusCode;
        }

        public static StatusCodeNames fromStatusCode(int statusCode) {
            for (StatusCodeNames code : StatusCodeNames.values()) {
                if (code.getStatusCode() != statusCode) continue;
                return code;
            }
            throw new IllegalArgumentException("Enum not found in StatusCodeNames");
        }

        public final int getStatusCode() {
            return this.statusCode;
        }
    }
}

