/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigSigModelSubscriptionList
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigSigModelSubscriptionList.class.getName());
    private static final int OP_CODE = 32810;
    private int mElementAddress;
    private int mModelIdentifier;
    private final List<Integer> mSubscriptionAddresses = new ArrayList<Integer>();

    public ConfigSigModelSubscriptionList(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Element Address: " + MeshAddress.formatAddress(this.mElementAddress, true));
        LOG.info("Model Identifier: " + Integer.toHexString(this.mModelIdentifier));
        for (int i = 5; i < this.mParameters.length; i += 2) {
            int address = MeshParserUtils.unsignedBytesToInt(this.mParameters[i], this.mParameters[i + 1]);
            this.mSubscriptionAddresses.add(address);
            LOG.info("Subscription Address: " + MeshAddress.formatAddress(address, false));
        }
    }

    @Override
    public int getOpCode() {
        return 32810;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public List<Integer> getSubscriptionAddresses() {
        return this.mSubscriptionAddresses;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

