/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.CompositionDataParser;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigSigModelAppList
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigSigModelAppList.class.getName());
    private static final int OP_CODE = 32844;
    private int mElementAddress;
    private int mModelIdentifier;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();

    public ConfigSigModelAppList(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Element address: " + MeshAddress.formatAddress(this.mElementAddress, false));
        LOG.info("Model identifier: " + CompositionDataParser.formatModelIdentifier(this.mModelIdentifier, false));
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 5));
        for (Integer keyIndex : this.mKeyIndexes) {
            LOG.info("AppKey Index: " + Integer.toHexString(keyIndex));
        }
    }

    @Override
    public final int getOpCode() {
        return 32844;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

