/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;

public final class ConfigRelayStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigRelayStatus.class.getName());
    private static final int OP_CODE = 32808;
    private int mRelay;
    private int mRelayRetransmitCount;
    private int mRelayRetransmitIntervalSteps;

    public ConfigRelayStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32808;
    }

    @Override
    final void parseStatusParameters() {
        byte[] payload = ((AccessMessage)this.mMessage).getAccessPdu();
        this.mRelay = payload[2];
        this.mRelayRetransmitCount = payload[3] & 7;
        this.mRelayRetransmitIntervalSteps = payload[3] >> 3 & 0x1F;
        LOG.info("Relay: " + this.mRelay);
        LOG.info("Retransmit count: " + this.mRelayRetransmitCount);
        LOG.info("Retransmit Interval steps: " + this.mRelayRetransmitIntervalSteps);
    }

    public int getRelay() {
        return this.mRelay;
    }

    public int getRelayRetransmitCount() {
        return this.mRelayRetransmitCount;
    }

    public int getRelayRetransmitIntervalSteps() {
        return this.mRelayRetransmitIntervalSteps;
    }
}

