/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigNodeIdentityStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNodeIdentityStatus.class.getName());
    private static final int OP_CODE = 32779;
    private int netKeyIndex;
    private int nodeIdentityState;

    public ConfigNodeIdentityStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        byte[] netKeyIndex = new byte[]{(byte)(this.mParameters[2] & 0xF), this.mParameters[1]};
        this.netKeyIndex = ByteBuffer.wrap(netKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
        this.nodeIdentityState = MeshParserUtils.unsignedByteToInt(this.mParameters[3]);
        LOG.info("Status: " + this.mStatusCode);
        LOG.info("Node Identity State: " + this.nodeIdentityState);
    }

    @Override
    public int getOpCode() {
        return 32779;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int getNodeIdentityState() {
        return this.nodeIdentityState;
    }

    public int getNetKeyIndex() {
        return this.netKeyIndex;
    }
}

