/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;

public final class ConfigNetworkTransmitStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNetworkTransmitStatus.class.getName());
    private static final int OP_CODE = 32805;
    private int mNetworkTransmitCount;
    private int mNetworkTransmitIntervalSteps;

    public ConfigNetworkTransmitStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32805;
    }

    @Override
    final void parseStatusParameters() {
        byte[] payload = ((AccessMessage)this.mMessage).getAccessPdu();
        this.mNetworkTransmitCount = payload[2] & 7;
        this.mNetworkTransmitIntervalSteps = payload[2] >> 3 & 0x1F;
    }

    public int getNetworkTransmitCount() {
        return this.mNetworkTransmitCount;
    }

    public int getNetworkTransmitIntervalSteps() {
        return this.mNetworkTransmitIntervalSteps;
    }
}

