/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigNetKeyUpdate
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNetKeyUpdate.class.getName());
    private static final int OP_CODE = 32837;
    private final NetworkKey mNetKey;

    public ConfigNetKeyUpdate(NetworkKey networkKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32837;
    }

    @Override
    void assembleMessageParameters() {
        LOG.info("NetKeyIndex: " + this.mNetKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[0]);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put(this.mNetKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

