/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;

public class ConfigNetKeyStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNetKeyStatus.class.getName());
    private static final int OP_CODE = 32836;
    private int mNetKeyIndex;

    public ConfigNetKeyStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        ArrayList<Integer> keyIndexes = this.decode(this.mParameters.length, 1);
        this.mNetKeyIndex = keyIndexes.get(0);
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Net key index: " + Integer.toHexString(this.mNetKeyIndex));
    }

    @Override
    public final int getOpCode() {
        return 32836;
    }

    public final int getNetKeyIndex() {
        return this.mNetKeyIndex;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

