/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;

public class ConfigNetKeyList
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNetKeyList.class.getName());
    private static final int OP_CODE = 32835;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();

    public ConfigNetKeyList(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 0));
        for (Integer keyIndex : this.mKeyIndexes) {
            LOG.info("Key Index: " + Integer.toHexString(keyIndex));
        }
    }

    @Override
    public final int getOpCode() {
        return 32835;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

