/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigNetKeyAdd
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigNetKeyAdd.class.getName());
    private static final int OP_CODE = 32832;
    private final NetworkKey mNetKey;

    public ConfigNetKeyAdd(NetworkKey networkKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32832;
    }

    @Override
    void assembleMessageParameters() {
        LOG.info("NetKeyIndex: " + this.mNetKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(18).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)(netKeyIndex[0] & 0xFF & 0xF));
        paramsBuffer.put(this.mNetKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

