/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public final class ConfigModelSubscriptionVirtualAddressDelete
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigModelSubscriptionVirtualAddressDelete.class.getName());
    private static final int OP_CODE = 32801;
    private static final int CONFIG_MODEL_SUBSCRIPTION_VIRTUAL_ADDRESS_DELETE_LENGTH = 20;
    private static final int VENDOR_MODEL_SUBSCRIPTION_VIRTUAL_ADDRESS_DELETE_LENGTH = 22;
    private final int mElementAddress;
    private final UUID labelUuid;
    private final int mModelIdentifier;

    public ConfigModelSubscriptionVirtualAddressDelete(int elementAddress, UUID labelUuid, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        this.labelUuid = labelUuid;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32801;
    }

    @Override
    void assembleMessageParameters() {
        byte[] elementAddress = MeshAddress.addressIntToBytes(this.mElementAddress);
        byte[] subscriptionAddress = MeshParserUtils.uuidToBytes(this.labelUuid);
        if (this.mModelIdentifier >= Short.MIN_VALUE && this.mModelIdentifier <= Short.MAX_VALUE) {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            paramsBuffer.put(subscriptionAddress);
            paramsBuffer.putShort((short)this.mModelIdentifier);
            this.mParameters = paramsBuffer.array();
        } else {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(22).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            paramsBuffer.put(subscriptionAddress);
            byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
            this.mParameters = paramsBuffer.array();
        }
    }

    public UUID getLabelUuid() {
        return this.labelUuid;
    }
}

