/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigModelSubscriptionStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigModelSubscriptionStatus.class.getName());
    private static final int OP_CODE = 32799;
    private static final int CONFIG_MODEL_PUBLICATION_STATUS_SIG_MODEL_PDU_LENGTH = 7;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL_PDU_LENGTH = 9;
    private int mElementAddress;
    private int mModelIdentifier;
    private int mSubscriptionAddress;

    public ConfigModelSubscriptionStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mSubscriptionAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        this.mModelIdentifier = this.mParameters.length == 7 ? MeshParserUtils.unsignedBytesToInt(this.mParameters[5], this.mParameters[6]) : MeshParserUtils.bytesToInt(new byte[]{this.mParameters[6], this.mParameters[5], this.mParameters[8], this.mParameters[7]});
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Element Address: " + MeshAddress.formatAddress(this.mElementAddress, true));
        LOG.info("Subscription Address: " + MeshAddress.formatAddress(this.mSubscriptionAddress, true));
        LOG.info("Model Identifier: " + Integer.toHexString(this.mModelIdentifier));
    }

    @Override
    public int getOpCode() {
        return 32799;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public int getSubscriptionAddress() {
        return this.mSubscriptionAddress;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

