/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;

public final class ConfigModelSubscriptionDeleteAll
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigModelSubscriptionDeleteAll.class.getName());
    private static final int OP_CODE = 32797;
    private static final int SIG_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 4;
    private static final int VENDOR_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 6;
    private final int mElementAddress;
    private final int mModelIdentifier;

    public ConfigModelSubscriptionDeleteAll(int elementAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32797;
    }

    @Override
    void assembleMessageParameters() {
        byte[] elementAddress = MeshAddress.addressIntToBytes(this.mElementAddress);
        if (this.mModelIdentifier >= Short.MIN_VALUE && this.mModelIdentifier <= Short.MAX_VALUE) {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            paramsBuffer.putShort((short)this.mModelIdentifier);
            this.mParameters = paramsBuffer.array();
        } else {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.put(elementAddress[1]);
            paramsBuffer.put(elementAddress[0]);
            byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
            this.mParameters = paramsBuffer.array();
        }
    }
}

