/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigModelAppStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigModelAppStatus.class.getName());
    private static final String TAG = ConfigModelAppStatus.class.getSimpleName();
    private static final int OP_CODE = 32830;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_SIG_MODEL = 7;
    private static final int CONFIG_MODEL_APP_BIND_STATUS_VENDOR_MODEL = 9;
    private int mElementAddress;
    private int mAppKeyIndex;
    private int mModelIdentifier;

    public ConfigModelAppStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        ByteBuffer buffer = ByteBuffer.wrap(message.getParameters()).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mStatusCode = buffer.get();
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        byte[] appKeyIndex = new byte[]{(byte)(this.mParameters[4] & 0xF), this.mParameters[3]};
        this.mAppKeyIndex = ByteBuffer.wrap(appKeyIndex).order(ByteOrder.BIG_ENDIAN).getShort();
        if (this.mParameters.length == 7) {
            this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[5], this.mParameters[6]);
        } else {
            byte[] modelIdentifier = new byte[]{this.mParameters[6], this.mParameters[5], this.mParameters[8], this.mParameters[7]};
            this.mModelIdentifier = ByteBuffer.wrap(modelIdentifier).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Element address: " + MeshAddress.formatAddress(this.mElementAddress, false));
        LOG.info("App key index: " + MeshParserUtils.bytesToHex(appKeyIndex, false));
        LOG.info("Model identifier: " + Integer.toHexString(this.mModelIdentifier));
    }

    @Override
    public int getOpCode() {
        return 32830;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public final int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

