/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;

class ConfigMessageState
extends MeshMessageState {
    private final byte[] mDeviceKey;

    ConfigMessageState(int src, int dst, byte[] deviceKey, MeshMessage meshMessage, MeshTransport meshTransport, InternalMeshMsgHandlerCallbacks callbacks) {
        super(meshMessage, meshTransport, callbacks);
        this.mSrc = src;
        this.mDst = dst;
        this.mDeviceKey = deviceKey;
        this.createAccessMessage();
    }

    @Override
    public synchronized MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.CONFIG_MESSAGE_STATE;
    }

    private synchronized void createAccessMessage() throws IllegalArgumentException {
        ConfigMessage configMessage = (ConfigMessage)this.mMeshMessage;
        int akf = configMessage.getAkf();
        int aid = configMessage.getAid();
        int aszmic = configMessage.getAszmic();
        int opCode = configMessage.getOpCode();
        byte[] parameters = configMessage.getParameters();
        this.message = this.mMeshTransport.createMeshMessage(this.mSrc, this.mDst, configMessage.messageTtl, this.mDeviceKey, akf, aid, aszmic, opCode, parameters);
        configMessage.setMessage(this.message);
    }
}

