/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigLowPowerNodePollTimeoutStatus
extends ConfigStatusMessage {
    private static final String TAG = ConfigLowPowerNodePollTimeoutStatus.class.getSimpleName();
    private static final int OP_CODE = 32814;
    private int address;
    private int pollTimeout;

    public ConfigLowPowerNodePollTimeoutStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.address = MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]);
        this.pollTimeout = MeshParserUtils.convert24BitsToInt(new byte[]{this.mParameters[2], this.mParameters[3], this.mParameters[4]});
    }

    @Override
    public int getOpCode() {
        return 32814;
    }

    public int getAddress() {
        return this.address;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }
}

