/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigKeyRefreshPhaseSet
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigKeyRefreshPhaseSet.class.getName());
    private static final int OP_CODE = 32790;
    private final NetworkKey mNetKey;
    private final int transition;

    public ConfigKeyRefreshPhaseSet(NetworkKey networkKey, int transition) {
        this.mNetKey = networkKey;
        this.transition = transition;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32790;
    }

    @Override
    void assembleMessageParameters() {
        LOG.info("NetKeyIndex: " + this.mNetKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        this.mParameters = new byte[]{netKeyIndex[1], (byte)(netKeyIndex[0] & 0xFF & 0xF), (byte)this.transition};
    }
}

