/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.HeartbeatSubscription;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatSubscriptionStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigHeartbeatSubscriptionStatus.class.getName());
    private static final int OP_CODE = 32828;
    private HeartbeatSubscription heartbeatSubscription;

    public ConfigHeartbeatSubscriptionStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32828;
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        int srcAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        int dstAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        int periodLog = MeshParserUtils.unsignedByteToInt(this.mParameters[5]);
        int countLog = MeshParserUtils.unsignedByteToInt(this.mParameters[6]);
        int minHops = MeshParserUtils.unsignedByteToInt(this.mParameters[7]);
        int maxHops = MeshParserUtils.unsignedByteToInt(this.mParameters[8]);
        this.heartbeatSubscription = new HeartbeatSubscription(srcAddress, dstAddress, (byte)periodLog, (byte)countLog, minHops, maxHops);
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Heartbeat subscription: " + this.heartbeatSubscription.toString());
    }

    public HeartbeatSubscription getHeartbeatSubscription() {
        return this.heartbeatSubscription;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }
}

