/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.Features;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.DeviceFeatureUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.HeartbeatPublication;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigHeartbeatPublicationStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigHeartbeatPublicationStatus.class.getName());
    private static final int OP_CODE = 6;
    private HeartbeatPublication heartbeatPublication;

    public ConfigHeartbeatPublicationStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 6;
    }

    @Override
    void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        int dst = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        int countLog = MeshParserUtils.unsignedByteToInt(this.mParameters[3]);
        int periodLog = MeshParserUtils.unsignedByteToInt(this.mParameters[4]);
        int ttl = MeshParserUtils.unsignedByteToInt(this.mParameters[5]);
        int featuresInt = MeshParserUtils.unsignedBytesToInt(this.mParameters[6], this.mParameters[7]);
        Features features = new Features(DeviceFeatureUtils.getFriendFeature(featuresInt), DeviceFeatureUtils.getLowPowerFeature(featuresInt), DeviceFeatureUtils.getProxyFeature(featuresInt), DeviceFeatureUtils.getRelayFeature(featuresInt));
        int netKeyIndex = MeshParserUtils.unsignedBytesToInt(this.mParameters[8], this.mParameters[9]);
        this.heartbeatPublication = new HeartbeatPublication(dst, (byte)countLog, (byte)periodLog, ttl, features, netKeyIndex);
        LOG.info("Status code: " + this.mStatusCode);
        LOG.info("Status message: " + this.mStatusCodeName);
        LOG.info("Heartbeat publication: " + this.heartbeatPublication.toString());
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public HeartbeatPublication getHeartbeatPublication() {
        return this.heartbeatPublication;
    }
}

