/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModelParser;
import org.openremote.agent.protocol.bluetooth.mesh.models.VendorModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Element;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.utils.DeviceFeatureUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigCompositionDataStatus
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigCompositionDataStatus.class.getName());
    private static final String TAG = ConfigCompositionDataStatus.class.getSimpleName();
    private static final int OP_CODE = 2;
    private static final int ELEMENTS_OFFSET = 12;
    private int companyIdentifier;
    private int productIdentifier;
    private int versionIdentifier;
    private int crpl;
    private int features;
    private boolean relayFeatureSupported;
    private boolean proxyFeatureSupported;
    private boolean friendFeatureSupported;
    private boolean lowPowerFeatureSupported;
    private Map<Integer, Element> mElements = new LinkedHashMap<Integer, Element>();

    public ConfigCompositionDataStatus(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.parseCompositionDataPages();
    }

    private void parseCompositionDataPages() {
        AccessMessage message = (AccessMessage)this.mMessage;
        byte[] accessPayload = message.getAccessPdu();
        this.companyIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[2], accessPayload[3]);
        LOG.info("Company identifier: " + String.format(Locale.US, "%04X", this.companyIdentifier));
        this.productIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[4], accessPayload[5]);
        LOG.info("Product identifier: " + String.format(Locale.US, "%04X", this.productIdentifier));
        this.versionIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[6], accessPayload[7]);
        LOG.info("Version identifier: " + String.format(Locale.US, "%04X", this.versionIdentifier));
        this.crpl = MeshParserUtils.unsignedBytesToInt(accessPayload[8], accessPayload[9]);
        LOG.info("crpl: " + String.format(Locale.US, "%04X", this.crpl));
        this.features = MeshParserUtils.unsignedBytesToInt(accessPayload[10], accessPayload[11]);
        LOG.info("Features: " + String.format(Locale.US, "%04X", this.features));
        this.relayFeatureSupported = DeviceFeatureUtils.supportsRelayFeature(this.features);
        LOG.info("Relay feature: " + this.relayFeatureSupported);
        this.proxyFeatureSupported = DeviceFeatureUtils.supportsProxyFeature(this.features);
        LOG.info("Proxy feature: " + this.proxyFeatureSupported);
        this.friendFeatureSupported = DeviceFeatureUtils.supportsFriendFeature(this.features);
        LOG.info("Friend feature: " + this.friendFeatureSupported);
        this.lowPowerFeatureSupported = DeviceFeatureUtils.supportsLowPowerFeature(this.features);
        LOG.info("Low power feature: " + this.lowPowerFeatureSupported);
        this.parseElements(accessPayload, message.getSrc());
        LOG.info("Number of elements: " + this.mElements.size());
    }

    private void parseElements(byte[] accessPayload, int src) {
        int tempOffset = 12;
        int counter = 0;
        int elementAddress = 0;
        while (tempOffset < accessPayload.length) {
            int i;
            LinkedHashMap<Integer, MeshModel> models = new LinkedHashMap<Integer, MeshModel>();
            int locationDescriptor = accessPayload[tempOffset + 1] << 8 | accessPayload[tempOffset];
            LOG.info("Location identifier: " + String.format(Locale.US, "%04X", locationDescriptor));
            int numSigModelIds = accessPayload[tempOffset += 2];
            LOG.info("Number of sig models: " + String.format(Locale.US, "%04X", numSigModelIds));
            int numVendorModelIds = accessPayload[++tempOffset];
            LOG.info("Number of vendor models: " + String.format(Locale.US, "%04X", numVendorModelIds));
            ++tempOffset;
            if (numSigModelIds > 0) {
                for (i = 0; i < numSigModelIds; ++i) {
                    int modelId = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset], accessPayload[tempOffset + 1]);
                    models.put(modelId, SigModelParser.getSigModel(modelId));
                    LOG.info("Sig model ID " + i + " : " + String.format(Locale.US, "%04X", modelId));
                    tempOffset += 2;
                }
            }
            if (numVendorModelIds > 0) {
                for (i = 0; i < numVendorModelIds; ++i) {
                    int companyIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset], accessPayload[tempOffset + 1]);
                    int modelIdentifier = MeshParserUtils.unsignedBytesToInt(accessPayload[tempOffset + 2], accessPayload[tempOffset + 3]);
                    int vendorModelIdentifier = companyIdentifier << 16 | modelIdentifier;
                    models.put(vendorModelIdentifier, new VendorModel(vendorModelIdentifier));
                    LOG.info("Vendor - model ID " + i + " : " + String.format(Locale.US, "%08X", vendorModelIdentifier));
                    tempOffset += 4;
                }
            }
            elementAddress = counter == 0 ? src : ++elementAddress;
            ++counter;
            Element element = new Element(elementAddress, locationDescriptor, models);
            int unicastAddress = elementAddress;
            this.mElements.put(unicastAddress, element);
        }
    }

    public int getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public int getProductIdentifier() {
        return this.productIdentifier;
    }

    public int getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public int getCrpl() {
        return this.crpl;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isRelayFeatureSupported() {
        return this.relayFeatureSupported;
    }

    public boolean isProxyFeatureSupported() {
        return this.proxyFeatureSupported;
    }

    public boolean isFriendFeatureSupported() {
        return this.friendFeatureSupported;
    }

    public boolean isLowPowerFeatureSupported() {
        return this.lowPowerFeatureSupported;
    }

    public Map<Integer, Element> getElements() {
        return this.mElements;
    }

    private int parseCompanyIdentifier(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    private int parseProductIdentifier(short productIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(productIdentifier).getShort(0);
    }

    private int parseVersionIdentifier(short versionIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(versionIdentifier).getShort(0);
    }

    private int parseCrpl(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    private int parseFeatures(short companyIdentifier) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(companyIdentifier).getShort(0);
    }

    @Override
    public int getOpCode() {
        return 2;
    }
}

