/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigStatusMessage;

public class ConfigAppKeyList
extends ConfigStatusMessage {
    public static final Logger LOG = Logger.getLogger(ConfigAppKeyList.class.getName());
    private static final int OP_CODE = 32770;
    private int mNetKeyIndex;
    private final List<Integer> mKeyIndexes = new ArrayList<Integer>();

    public ConfigAppKeyList(AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mNetKeyIndex = this.decode(3, 1).get(0);
        LOG.info("NetKey Index: " + Integer.toHexString(this.mNetKeyIndex));
        this.mKeyIndexes.addAll(this.decode(this.mParameters.length, 3));
        for (Integer keyIndex : this.mKeyIndexes) {
            LOG.info("AppKey Index: " + Integer.toHexString(keyIndex));
        }
    }

    @Override
    public final int getOpCode() {
        return 32770;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int getNetKeyIndex() {
        return this.mNetKeyIndex;
    }

    public List<Integer> getKeyIndexes() {
        return this.mKeyIndexes;
    }
}

