/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ConfigAppKeyAdd
extends ConfigMessage {
    public static final Logger LOG = Logger.getLogger(ConfigAppKeyAdd.class.getName());
    private static final int OP_CODE = 0;
    private final NetworkKey mNetKey;
    private final ApplicationKey mAppKey;

    public ConfigAppKeyAdd(NetworkKey networkKey, ApplicationKey appKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        if (appKey.getKey().length != 16) {
            throw new IllegalArgumentException("App key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.mAppKey = appKey;
        this.assembleMessageParameters();
    }

    public NetworkKey getNetKey() {
        return this.mNetKey;
    }

    public ApplicationKey getAppKey() {
        return this.mAppKey;
    }

    @Override
    public int getOpCode() {
        return 0;
    }

    @Override
    void assembleMessageParameters() {
        LOG.info("NetKeyIndex: " + this.mNetKey.getKeyIndex());
        LOG.info("AppKeyIndex: " + this.mAppKey.getKeyIndex());
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        byte[] appKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mAppKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(19).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)((appKeyIndex[1] & 0xFF) << 4 | netKeyIndex[0] & 0xFF & 0xF));
        paramsBuffer.put((byte)((appKeyIndex[0] & 0xFF) << 4 | (appKeyIndex[1] & 0xFF) >> 4));
        paramsBuffer.put(this.mAppKey.getKey());
        this.mParameters = paramsBuffer.array();
    }
}

