/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.MeshStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ConfigMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.DefaultNoOperationMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.InternalMeshMsgHandlerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageHandlerApi;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshTransport;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayer;
import org.openremote.agent.protocol.bluetooth.mesh.transport.NetworkLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProxyConfigMessageState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.UpperTransportLayerCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageAcked;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageAckedState;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageUnacked;
import org.openremote.agent.protocol.bluetooth.mesh.transport.VendorModelMessageUnackedState;
import org.openremote.agent.protocol.bluetooth.mesh.utils.ExtendedInvalidCipherTextException;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public abstract class BaseMeshMessageHandler
implements MeshMessageHandlerApi,
InternalMeshMsgHandlerCallbacks {
    public static final Logger LOG = Logger.getLogger(BaseMeshMessageHandler.class.getName());
    protected final InternalTransportCallbacks mInternalTransportCallbacks;
    private final NetworkLayerCallbacks networkLayerCallbacks;
    private final UpperTransportLayerCallbacks upperTransportLayerCallbacks;
    protected MeshStatusCallbacks mStatusCallbacks;
    private final Map<Integer, MeshTransport> transportSparseArray = new HashMap<Integer, MeshTransport>();
    private final Map<Integer, MeshMessageState> stateSparseArray = new HashMap<Integer, MeshMessageState>();

    protected BaseMeshMessageHandler(InternalTransportCallbacks internalTransportCallbacks, NetworkLayerCallbacks networkLayerCallbacks, UpperTransportLayerCallbacks upperTransportLayerCallbacks) {
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.networkLayerCallbacks = networkLayerCallbacks;
        this.upperTransportLayerCallbacks = upperTransportLayerCallbacks;
    }

    protected abstract void setMeshStatusCallbacks(MeshStatusCallbacks var1);

    protected synchronized void parseMeshPduNotifications(byte[] pdu, MeshNetwork network) throws ExtendedInvalidCipherTextException {
        int ivIndex;
        List<NetworkKey> networkKeys = network.getNetKeys();
        int ivi = (pdu[1] & 0xFF) >>> 7 & 1;
        int nid = pdu[1] & 0x7F;
        NetworkKey networkKey = null;
        SecureUtils.K2Output k2Output = null;
        byte[] networkHeader = null;
        byte ctlTtl = 0;
        int ctl = 0;
        int src = 0;
        ProvisionedMeshNode node = null;
        for (int tempIvIndex = ivIndex = (acceptedIvIndex = network.getIvIndex().getIvIndex()) == 0 ? 0 : acceptedIvIndex - 1; tempIvIndex <= ivIndex + 1; ++tempIvIndex) {
            for (int i = 0; i < networkKeys.size(); ++i) {
                networkKey = networkKeys.get(i);
                k2Output = this.getMatchingK2Output(networkKey, nid);
                if (k2Output == null) continue;
                networkHeader = NetworkLayer.deObfuscateNetworkHeader(pdu, MeshParserUtils.intToBytes(tempIvIndex), k2Output.getPrivacyKey());
                ctlTtl = networkHeader[0];
                ctl = ctlTtl >> 7 & 1;
                src = MeshParserUtils.unsignedBytesToInt(networkHeader[5], networkHeader[4]);
                node = network.getNode(src);
                if (node != null) break;
            }
            if (node == null || k2Output == null) continue;
            byte[] sequenceNumber = ByteBuffer.allocate(3).order(ByteOrder.BIG_ENDIAN).put(networkHeader, 1, 3).array();
            LOG.info("Sequence number of received Network PDU: " + MeshParserUtils.convert24BitsToInt(sequenceNumber));
            try {
                MeshMessageState state;
                byte[] decryptedPayload;
                int networkPayloadLength = pdu.length - (2 + networkHeader.length);
                byte[] transportPdu = new byte[networkPayloadLength];
                System.arraycopy(pdu, 8, transportPdu, 0, networkPayloadLength);
                if (pdu[0] == 0) {
                    nonce = NetworkLayer.createNetworkNonce(ctlTtl, sequenceNumber, src, MeshParserUtils.intToBytes(tempIvIndex));
                    decryptedPayload = SecureUtils.decryptCCM(transportPdu, k2Output.getEncryptionKey(), nonce, SecureUtils.getNetMicLength(ctl));
                    state = this.getState(src);
                } else {
                    nonce = NetworkLayer.createProxyNonce(sequenceNumber, src, MeshParserUtils.intToBytes(tempIvIndex));
                    decryptedPayload = SecureUtils.decryptCCM(transportPdu, k2Output.getEncryptionKey(), nonce, SecureUtils.getNetMicLength(ctl));
                    state = this.getState(0);
                }
                if (state == null) continue;
                ((DefaultNoOperationMessageState)state).parseMeshPdu(networkKey, node, pdu, networkHeader, decryptedPayload, tempIvIndex, sequenceNumber);
                return;
            }
            catch (InvalidCipherTextException ex) {
                throw new ExtendedInvalidCipherTextException(ex.getMessage(), ex.getCause(), BaseMeshMessageHandler.class.getName());
            }
        }
    }

    private SecureUtils.K2Output getMatchingK2Output(NetworkKey networkKey, int nid) {
        if (nid == networkKey.getDerivatives().getNid()) {
            return networkKey.getDerivatives();
        }
        if (networkKey.getOldDerivatives() != null && nid == networkKey.getOldDerivatives().getNid()) {
            return networkKey.getOldDerivatives();
        }
        return null;
    }

    @Override
    public final synchronized void onIncompleteTimerExpired(int address) {
        this.stateSparseArray.put(address, this.toggleState(this.getTransport(address), this.getState(address).getMeshMessage()));
    }

    private DefaultNoOperationMessageState toggleState(MeshTransport transport, MeshMessage meshMessage) {
        DefaultNoOperationMessageState state = new DefaultNoOperationMessageState(meshMessage, transport, this);
        state.setTransportCallbacks(this.mInternalTransportCallbacks);
        state.setStatusCallbacks(this.mStatusCallbacks);
        return state;
    }

    protected synchronized MeshMessageState getState(int address) {
        MeshMessageState state = this.stateSparseArray.get(address);
        if (state == null) {
            state = new DefaultNoOperationMessageState(null, this.getTransport(address), this);
            state.setTransportCallbacks(this.mInternalTransportCallbacks);
            state.setStatusCallbacks(this.mStatusCallbacks);
            this.stateSparseArray.put(address, state);
        }
        return state;
    }

    private MeshTransport getTransport(int address) {
        MeshTransport transport = this.transportSparseArray.get(address);
        if (transport == null) {
            transport = new MeshTransport();
            transport.setNetworkLayerCallbacks(this.networkLayerCallbacks);
            transport.setUpperTransportLayerCallbacks(this.upperTransportLayerCallbacks);
            this.transportSparseArray.put(address, transport);
        }
        return transport;
    }

    public synchronized void resetState(int address) {
        this.stateSparseArray.remove(address);
        this.transportSparseArray.remove(address);
    }

    @Override
    public synchronized void createMeshMessage(int src, int dst, UUID label, MeshMessage meshMessage) {
        if (meshMessage instanceof ProxyConfigMessage) {
            this.createProxyConfigMeshMessage(src, dst, (ProxyConfigMessage)meshMessage);
        } else if (meshMessage instanceof ConfigMessage) {
            this.createConfigMeshMessage(src, dst, (ConfigMessage)meshMessage);
        } else if (meshMessage instanceof GenericMessage) {
            if (label == null) {
                this.createAppMeshMessage(src, dst, (GenericMessage)meshMessage);
            } else {
                this.createAppMeshMessage(src, dst, label, (GenericMessage)meshMessage);
            }
        }
    }

    private void createProxyConfigMeshMessage(int src, int dst, ProxyConfigMessage configurationMessage) {
        ProxyConfigMessageState currentState = new ProxyConfigMessageState(src, dst, configurationMessage, this.getTransport(dst), this);
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        this.stateSparseArray.put(dst, this.toggleState(currentState.getMeshTransport(), configurationMessage));
        currentState.executeSend();
    }

    private void createConfigMeshMessage(int src, int dst, ConfigMessage configurationMessage) {
        ProvisionedMeshNode node = this.mInternalTransportCallbacks.getNode(dst);
        if (node == null) {
            return;
        }
        ConfigMessageState currentState = new ConfigMessageState(src, dst, node.getDeviceKey(), configurationMessage, this.getTransport(dst), this);
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, this.toggleState(this.getTransport(dst), configurationMessage));
        }
        currentState.executeSend();
    }

    private void createAppMeshMessage(int src, int dst, GenericMessage genericMessage) {
        GenericMessageState currentState = genericMessage instanceof VendorModelMessageAcked ? new VendorModelMessageAckedState(src, dst, (VendorModelMessageAcked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : (genericMessage instanceof VendorModelMessageUnacked ? new VendorModelMessageUnackedState(src, dst, (VendorModelMessageUnacked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : new GenericMessageState(src, dst, genericMessage, this.getTransport(dst), this));
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, this.toggleState(this.getTransport(dst), genericMessage));
        }
        currentState.executeSend();
    }

    private void createAppMeshMessage(int src, int dst, UUID label, GenericMessage genericMessage) {
        GenericMessageState currentState = genericMessage instanceof VendorModelMessageAcked ? new VendorModelMessageAckedState(src, dst, label, (VendorModelMessageAcked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : (genericMessage instanceof VendorModelMessageUnacked ? new VendorModelMessageUnackedState(src, dst, label, (VendorModelMessageUnacked)genericMessage, this.getTransport(dst), (InternalMeshMsgHandlerCallbacks)this) : new GenericMessageState(src, dst, label, genericMessage, this.getTransport(dst), this));
        currentState.setTransportCallbacks(this.mInternalTransportCallbacks);
        currentState.setStatusCallbacks(this.mStatusCallbacks);
        if (MeshAddress.isValidUnicastAddress(dst)) {
            this.stateSparseArray.put(dst, this.toggleState(this.getTransport(dst), genericMessage));
        }
        currentState.executeSend();
    }
}

