/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.AccessMessage;
import org.openremote.agent.protocol.bluetooth.mesh.transport.Message;
import org.openremote.agent.protocol.bluetooth.mesh.transport.ProvisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

abstract class AccessLayer {
    public static final Logger LOG = Logger.getLogger(AccessLayer.class.getName());
    ProvisionedMeshNode mMeshNode;

    AccessLayer() {
    }

    synchronized void createMeshMessage(Message message) {
        this.createAccessMessage((AccessMessage)message);
    }

    synchronized void createVendorMeshMessage(Message message) {
        this.createCustomAccessMessage((AccessMessage)message);
    }

    final synchronized void createAccessMessage(AccessMessage accessMessage) {
        ByteBuffer accessMessageBuffer;
        byte[] opCodes = MeshParserUtils.getOpCode(accessMessage.getOpCode());
        byte[] parameters = accessMessage.getParameters();
        if (parameters != null) {
            accessMessageBuffer = ByteBuffer.allocate(opCodes.length + parameters.length);
            accessMessageBuffer.put(opCodes).put(parameters);
        } else {
            accessMessageBuffer = ByteBuffer.allocate(opCodes.length);
            accessMessageBuffer.put(opCodes);
        }
        byte[] accessPdu = accessMessageBuffer.array();
        LOG.info("Created Access PDU " + MeshParserUtils.bytesToHex(accessPdu, false));
        accessMessage.setAccessPdu(accessMessageBuffer.array());
    }

    final synchronized void createCustomAccessMessage(AccessMessage accessMessage) {
        ByteBuffer accessMessageBuffer;
        byte[] parameters = accessMessage.getParameters();
        byte[] vendorOpcode = MeshParserUtils.createVendorOpCode(accessMessage.getOpCode(), accessMessage.getCompanyIdentifier());
        if (parameters != null) {
            accessMessageBuffer = ByteBuffer.allocate(vendorOpcode.length + parameters.length);
            accessMessageBuffer.put(vendorOpcode);
            accessMessageBuffer.put(parameters);
        } else {
            accessMessageBuffer = ByteBuffer.allocate(vendorOpcode.length);
            accessMessageBuffer.put(vendorOpcode);
        }
        byte[] accessPdu = accessMessageBuffer.array();
        LOG.info("Created Access PDU " + MeshParserUtils.bytesToHex(accessPdu, false));
        accessMessage.setAccessPdu(accessPdu);
    }

    final synchronized void parseAccessLayerPDU(AccessMessage message) {
        byte[] accessPayload = message.getAccessPdu();
        int opCodeLength = MeshParserUtils.getOpCodeLength(accessPayload[0] & 0xFF);
        message.setOpCode(MeshParserUtils.getOpCode(accessPayload, opCodeLength));
        int length = accessPayload.length - opCodeLength;
        ByteBuffer paramsBuffer = ByteBuffer.allocate(length).order(ByteOrder.BIG_ENDIAN);
        paramsBuffer.put(accessPayload, opCodeLength, length);
        message.setParameters(paramsBuffer.array());
        LOG.info("Received Access PDU " + MeshParserUtils.bytesToHex(accessPayload, false));
    }
}

