/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.InternalProvisioningCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class ProvisioningRandomConfirmationState
extends ProvisioningState {
    public static final Logger LOG = Logger.getLogger(ProvisioningRandomConfirmationState.class.getName());
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    public ProvisioningRandomConfirmationState(InternalProvisioningCallbacks callbacks, UnprovisionedMeshNode unprovisionedMeshNode, InternalTransportCallbacks mInternalTransportCallbacks, MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.provisioningCallbacks = callbacks;
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_RANDOM;
    }

    @Override
    public void executeSend() {
        byte[] provisionerRandomConfirmationPDU = this.createProvisionerRandomPDU();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_CONFIRMATION_SENT, provisionerRandomConfirmationPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, provisionerRandomConfirmationPDU);
    }

    @Override
    public boolean parseData(byte[] data) {
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_RANDOM_RECEIVED, data);
        this.parseProvisioneeRandom(data);
        return this.provisioneeMatches();
    }

    private byte[] createProvisionerRandomPDU() {
        byte[] provisionerRandom = this.mUnprovisionedMeshNode.getProvisionerRandom();
        ByteBuffer buffer = ByteBuffer.allocate(provisionerRandom.length + 2);
        buffer.put(new byte[]{3, 6});
        buffer.put(provisionerRandom);
        byte[] data = buffer.array();
        LOG.info("Provisioner random PDU: " + MeshParserUtils.bytesToHex(data, false));
        return data;
    }

    private boolean provisioneeMatches() {
        byte[] provisioneeRandom = this.mUnprovisionedMeshNode.getProvisioneeRandom();
        byte[] confirmationInputs = this.provisioningCallbacks.generateConfirmationInputs(this.mUnprovisionedMeshNode.getProvisionerPublicKeyXY(), this.mUnprovisionedMeshNode.getProvisioneePublicKeyXY());
        LOG.info("Confirmation inputs: " + MeshParserUtils.bytesToHex(confirmationInputs, false));
        byte[] confirmationSalt = SecureUtils.calculateSalt(confirmationInputs);
        LOG.info("Confirmation salt: " + MeshParserUtils.bytesToHex(confirmationSalt, false));
        byte[] ecdhSecret = this.mUnprovisionedMeshNode.getSharedECDHSecret();
        byte[] confirmationKey = SecureUtils.calculateK1(ecdhSecret, confirmationSalt, SecureUtils.PRCK);
        LOG.info("Confirmation key: " + MeshParserUtils.bytesToHex(confirmationKey, false));
        byte[] authenticationValue = this.mUnprovisionedMeshNode.getAuthenticationValue();
        LOG.info("Authentication value: " + MeshParserUtils.bytesToHex(authenticationValue, false));
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeRandom.length + authenticationValue.length);
        buffer.put(provisioneeRandom);
        buffer.put(authenticationValue);
        byte[] confirmationData = buffer.array();
        byte[] confirmationValue = SecureUtils.calculateCMAC(confirmationData, confirmationKey);
        if (Arrays.equals(confirmationValue, this.mUnprovisionedMeshNode.getProvisioneeConfirmation())) {
            LOG.info("Confirmation values match!!!!: " + MeshParserUtils.bytesToHex(confirmationValue, false));
            return true;
        }
        return false;
    }

    private void parseProvisioneeRandom(byte[] provisioneeRandomPDU) {
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeRandomPDU.length - 2);
        buffer.put(provisioneeRandomPDU, 2, buffer.limit());
        this.mUnprovisionedMeshNode.setProvisioneeRandom(buffer.array());
    }
}

