/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.logging.Logger;
import javax.crypto.KeyAgreement;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;

public class ProvisioningPublicKeyState
extends ProvisioningState {
    private static final int PROVISIONING_PUBLIC_KEY_XY_PDU_LENGTH = 69;
    public static final Logger LOG = Logger.getLogger(ProvisioningPublicKeyState.class.getName());
    private final byte[] publicKeyXY = new byte[69];
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private byte[] mTempProvisioneeXY;
    private int segmentCount = 0;
    private ECPrivateKey mProvisionerPrivaetKey;

    public ProvisioningPublicKeyState(UnprovisionedMeshNode unprovisionedMeshNode, InternalTransportCallbacks mInternalTransportCallbacks, MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_PUBLIC_KEY;
    }

    @Override
    public void executeSend() {
        this.generateKeyPairs();
        byte[] pdu = this.generatePublicKeyXYPDU();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_PUBLIC_KEY_SENT, pdu);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, pdu);
    }

    @Override
    public boolean parseData(byte[] data) {
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_PUBLIC_KEY_RECEIVED, data);
        this.generateSharedECDHSecret(data);
        return true;
    }

    private void generateKeyPairs() {
        try {
            ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "SC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            this.mProvisionerPrivaetKey = (ECPrivateKey)keyPair.getPrivate();
            ECPoint point = publicKey.getQ();
            BigInteger x = point.getXCoord().toBigInteger();
            BigInteger y = point.getYCoord().toBigInteger();
            byte[] tempX = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)x);
            byte[] tempY = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)y);
            LOG.info("X: length: " + tempX.length + " " + MeshParserUtils.bytesToHex(tempX, false));
            LOG.info("Y: length: " + tempY.length + " " + MeshParserUtils.bytesToHex(tempY, false));
            byte[] tempXY = new byte[64];
            System.arraycopy(tempX, 0, tempXY, 0, tempX.length);
            System.arraycopy(tempY, 0, tempXY, tempY.length, tempY.length);
            this.mUnprovisionedMeshNode.setProvisionerPublicKeyXY(tempXY);
            LOG.info("XY: " + MeshParserUtils.bytesToHex(tempXY, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] generatePublicKeyXYPDU() {
        byte[] tempXY = this.mUnprovisionedMeshNode.getProvisionerPublicKeyXY();
        ByteBuffer buffer = ByteBuffer.allocate(tempXY.length + 2);
        buffer.put((byte)3);
        buffer.put((byte)3);
        buffer.put(tempXY);
        return buffer.array();
    }

    private void generateSharedECDHSecret(byte[] provisioneePublicKeyXYPDU) {
        if (provisioneePublicKeyXYPDU.length != 66) {
            throw new IllegalArgumentException("Invalid Provisionee Public Key PDU, length of the Provisionee public key must be 66 bytes, but was " + provisioneePublicKeyXYPDU.length);
        }
        ByteBuffer buffer = ByteBuffer.allocate(provisioneePublicKeyXYPDU.length - 2);
        buffer.put(provisioneePublicKeyXYPDU, 2, buffer.limit());
        this.mTempProvisioneeXY = buffer.array();
        byte[] xy = this.mTempProvisioneeXY;
        this.mUnprovisionedMeshNode.setProvisioneePublicKeyXY(xy);
        byte[] xComponent = new byte[32];
        System.arraycopy(xy, 0, xComponent, 0, xComponent.length);
        byte[] yComponent = new byte[32];
        System.arraycopy(xy, 32, yComponent, 0, xComponent.length);
        byte[] provisioneeX = this.convertToLittleEndian(xComponent, ByteOrder.LITTLE_ENDIAN);
        LOG.info("Provsionee X: " + MeshParserUtils.bytesToHex(provisioneeX, false));
        byte[] provisioneeY = this.convertToLittleEndian(yComponent, ByteOrder.LITTLE_ENDIAN);
        LOG.info("Provsionee Y: " + MeshParserUtils.bytesToHex(provisioneeY, false));
        BigInteger x = BigIntegers.fromUnsignedByteArray((byte[])xy, (int)0, (int)32);
        BigInteger y = BigIntegers.fromUnsignedByteArray((byte[])xy, (int)32, (int)32);
        ECNamedCurveParameterSpec ecParameters = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECCurve curve = ecParameters.getCurve();
        ECPoint ecPoint = curve.createPoint(x, y);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameters);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("ECDH", "SC");
            ECPublicKey publicKey = (ECPublicKey)keyFactory.generatePublic((KeySpec)keySpec);
            KeyAgreement a = KeyAgreement.getInstance("ECDH", "SC");
            a.init((Key)this.mProvisionerPrivaetKey);
            a.doPhase((Key)publicKey, true);
            byte[] sharedECDHSecret = a.generateSecret();
            this.mUnprovisionedMeshNode.setSharedECDHSecret(sharedECDHSecret);
            LOG.info("ECDH Secret: " + MeshParserUtils.bytesToHex(sharedECDHSecret, false));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
    }

    private byte[] convertToLittleEndian(byte[] data, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length);
        buffer.order(order);
        buffer.put(data);
        return buffer.array();
    }
}

