/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;

public class ProvisioningInviteState
extends ProvisioningState {
    public static final Logger LOG = Logger.getLogger(ProvisioningInviteState.class.getName());
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final int attentionTimer;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    public ProvisioningInviteState(UnprovisionedMeshNode unprovisionedMeshNode, int attentionTimer, InternalTransportCallbacks mInternalTransportCallbacks, MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        this.attentionTimer = attentionTimer;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_INVITE;
    }

    @Override
    public void executeSend() {
        byte[] invitePDU = this.createInvitePDU();
        this.mUnprovisionedMeshNode.setProvisioningInvitePdu(invitePDU);
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_INVITE, invitePDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, invitePDU);
    }

    @Override
    public boolean parseData(byte[] data) {
        return true;
    }

    private byte[] createInvitePDU() {
        byte[] data = new byte[]{3, 0, (byte)this.attentionTimer};
        return data;
    }
}

