/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;

public class ProvisioningFailedState
extends ProvisioningState {
    private int error;

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_FAILED;
    }

    @Override
    public void executeSend() {
    }

    @Override
    public boolean parseData(byte[] data) {
        this.error = data[2];
        return true;
    }

    public int getErrorCode() {
        return this.error;
    }

    public static String parseProvisioningFailure(int errorCode) {
        switch (ProvisioningFailureCode.fromErrorCode(errorCode)) {
            case PROHIBITED: {
                return "PROHIBITED";
            }
            case INVALID_PDU: {
                return "INVALID_PDU";
            }
            case INVALID_FORMAT: {
                return "INVALID_FORMAT";
            }
            case UNEXPECTED_PDU: {
                return "UNEXPECTED_PDU";
            }
            case CONFIRMATION_FAILED: {
                return "CONFIRMATION_FAILED";
            }
            case OUT_OF_RESOURCES: {
                return "OUT_OF_RESOURCES";
            }
            case DECRYPTION_FAILED: {
                return "DECRYPTION_FAILED";
            }
            case UNEXPECTED_ERROR: {
                return "UNEXPECTED_ERROR";
            }
            case CANNOT_ASSIGN_ADDRESSES: {
                return "CANNOT_ASSIGN_ADDRESSES";
            }
        }
        return "UNKNOWN_ERROR_CODE";
    }

    public static enum ProvisioningFailureCode {
        PROHIBITED(0),
        INVALID_PDU(1),
        INVALID_FORMAT(2),
        UNEXPECTED_PDU(3),
        CONFIRMATION_FAILED(4),
        OUT_OF_RESOURCES(5),
        DECRYPTION_FAILED(6),
        UNEXPECTED_ERROR(7),
        CANNOT_ASSIGN_ADDRESSES(8),
        UNKNOWN_ERROR_CODE(9);

        private final int errorCode;

        private ProvisioningFailureCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public static ProvisioningFailureCode fromErrorCode(int errorCode) {
            for (ProvisioningFailureCode failureCode : ProvisioningFailureCode.values()) {
                if (failureCode.getErrorCode() != errorCode) continue;
                return failureCode;
            }
            return UNKNOWN_ERROR_CODE;
        }

        public final int getErrorCode() {
            return this.errorCode;
        }
    }
}

