/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.InternalProvisioningCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshAddress;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class ProvisioningDataState
extends ProvisioningState {
    public static final Logger LOG = Logger.getLogger(ProvisioningDataState.class.getName());
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    public ProvisioningDataState(InternalProvisioningCallbacks callbacks, UnprovisionedMeshNode unprovisionedMeshNode, InternalTransportCallbacks mInternalTransportCallbacks, MeshProvisioningStatusCallbacks meshProvisioningStatusCallbacks) {
        this.provisioningCallbacks = callbacks;
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
        this.mInternalTransportCallbacks = mInternalTransportCallbacks;
        this.mStatusCallbacks = meshProvisioningStatusCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_DATA;
    }

    @Override
    public void executeSend() {
        this.sendProvisioningData();
    }

    @Override
    public boolean parseData(byte[] data) {
        return true;
    }

    private void sendProvisioningData() {
        byte[] provisioningDataPDU = this.createProvisioningDataPDU();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_DATA_SENT, provisioningDataPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mUnprovisionedMeshNode, provisioningDataPDU);
    }

    private byte[] createProvisioningDataPDU() {
        byte[] provisioningSalt = this.generateProvisioningSalt();
        LOG.info("Provisioning salt: " + MeshParserUtils.bytesToHex(provisioningSalt, false));
        byte[] ecdh = this.mUnprovisionedMeshNode.getSharedECDHSecret();
        byte[] t = SecureUtils.calculateCMAC(ecdh, provisioningSalt);
        byte[] sessionKey = SecureUtils.calculateCMAC(SecureUtils.PRSK, t);
        LOG.info("Session key: " + MeshParserUtils.bytesToHex(sessionKey, false));
        byte[] sessionNonce = this.generateSessionNonce(ecdh, provisioningSalt);
        LOG.info("Session nonce: " + MeshParserUtils.bytesToHex(sessionNonce, false));
        byte[] deviceKey = SecureUtils.calculateCMAC(SecureUtils.PRDK, t);
        LOG.info("Device key: " + MeshParserUtils.bytesToHex(deviceKey, false));
        this.mUnprovisionedMeshNode.setDeviceKey(deviceKey);
        byte[] networkKey = this.mUnprovisionedMeshNode.getNetworkKey();
        LOG.info("Network key: " + MeshParserUtils.bytesToHex(networkKey, false));
        byte[] keyIndex = MeshParserUtils.addKeyIndexPadding(this.mUnprovisionedMeshNode.getKeyIndex());
        LOG.info("Key index: " + MeshParserUtils.bytesToHex(keyIndex, false));
        byte[] flags = this.mUnprovisionedMeshNode.getFlags();
        LOG.info("Flags: " + MeshParserUtils.bytesToHex(flags, false));
        byte[] ivIndex = this.mUnprovisionedMeshNode.getIvIndex();
        LOG.info("IV index: " + MeshParserUtils.bytesToHex(ivIndex, false));
        byte[] unicastAddress = MeshAddress.addressIntToBytes(this.mUnprovisionedMeshNode.getUnicastAddress());
        LOG.info("Unicast address: " + MeshParserUtils.bytesToHex(unicastAddress, false));
        ByteBuffer buffer = ByteBuffer.allocate(networkKey.length + keyIndex.length + flags.length + ivIndex.length + unicastAddress.length);
        buffer.put(networkKey);
        buffer.put(keyIndex);
        buffer.put(flags);
        buffer.put(ivIndex);
        buffer.put(unicastAddress);
        byte[] provisioningData = buffer.array();
        LOG.info("Provisioning data: " + MeshParserUtils.bytesToHex(provisioningData, false));
        byte[] encryptedProvisioningData = SecureUtils.encryptCCM(provisioningData, sessionKey, sessionNonce, 8);
        LOG.info("Encrypted provisioning data: " + MeshParserUtils.bytesToHex(encryptedProvisioningData, false));
        buffer = ByteBuffer.allocate(2 + encryptedProvisioningData.length);
        buffer.put((byte)3);
        buffer.put((byte)7);
        buffer.put(encryptedProvisioningData);
        byte[] provisioningPDU = buffer.array();
        LOG.info("Prov Data: " + MeshParserUtils.bytesToHex(provisioningPDU, false));
        return provisioningPDU;
    }

    private byte[] generateProvisioningSalt() {
        byte[] confirmationSalt = SecureUtils.calculateSalt(this.provisioningCallbacks.generateConfirmationInputs(this.mUnprovisionedMeshNode.getProvisionerPublicKeyXY(), this.mUnprovisionedMeshNode.getProvisioneePublicKeyXY()));
        byte[] provisionerRandom = this.mUnprovisionedMeshNode.getProvisionerRandom();
        byte[] provisioneeRandom = this.mUnprovisionedMeshNode.getProvisioneeRandom();
        ByteBuffer buffer = ByteBuffer.allocate(confirmationSalt.length + provisionerRandom.length + provisioneeRandom.length);
        buffer.put(confirmationSalt);
        buffer.put(provisionerRandom);
        buffer.put(provisioneeRandom);
        return SecureUtils.calculateSalt(buffer.array());
    }

    private byte[] generateSessionNonce(byte[] ecdh, byte[] provisioningSalt) {
        byte[] nonce = SecureUtils.calculateK1(ecdh, provisioningSalt, SecureUtils.PRSN);
        ByteBuffer buffer = ByteBuffer.allocate(nonce.length - 3);
        buffer.put(nonce, 3, buffer.limit());
        return buffer.array();
    }
}

