/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.InternalProvisioningCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.InternalTransportCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;
import org.openremote.agent.protocol.bluetooth.mesh.utils.InputOOBAction;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.agent.protocol.bluetooth.mesh.utils.OutputOOBAction;
import org.openremote.agent.protocol.bluetooth.mesh.utils.SecureUtils;

public class ProvisioningConfirmationState
extends ProvisioningState {
    public static final Logger LOG = Logger.getLogger(ProvisioningConfirmationState.class.getName());
    private static final byte[] NO_OOB_AUTH = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int AUTH_VALUE_LENGTH = 16;
    private final InternalProvisioningCallbacks provisioningCallbacks;
    private final UnprovisionedMeshNode mNode;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;
    private String authentication;
    private byte[] authenticationValue;

    public ProvisioningConfirmationState(InternalProvisioningCallbacks callbacks, UnprovisionedMeshNode node, InternalTransportCallbacks internalTransportCallbacks, MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.provisioningCallbacks = callbacks;
        this.mNode = node;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
        this.mStatusCallbacks = provisioningStatusCallbacks;
    }

    public void setProvisioningAuthentication(String authentication) {
        this.authentication = authentication;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_CONFIRMATION;
    }

    @Override
    public void executeSend() {
        byte[] provisioningConfirmationPDU = this.createProvisioningConfirmation();
        this.mStatusCallbacks.onProvisioningStateChanged(this.mNode, ProvisioningState.States.PROVISIONING_CONFIRMATION_SENT, provisioningConfirmationPDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.mNode, provisioningConfirmationPDU);
    }

    @Override
    public boolean parseData(byte[] data) {
        this.mStatusCallbacks.onProvisioningStateChanged(this.mNode, ProvisioningState.States.PROVISIONING_CONFIRMATION_RECEIVED, data);
        this.parseProvisioneeConfirmation(data);
        return true;
    }

    private byte[] createProvisioningConfirmation() {
        byte[] confirmationInputs = this.provisioningCallbacks.generateConfirmationInputs(this.mNode.getProvisionerPublicKeyXY(), this.mNode.getProvisioneePublicKeyXY());
        LOG.info("Confirmation inputs: " + MeshParserUtils.bytesToHex(confirmationInputs, false));
        byte[] confirmationSalt = SecureUtils.calculateSalt(confirmationInputs);
        LOG.info("Confirmation salt: " + MeshParserUtils.bytesToHex(confirmationSalt, false));
        byte[] ecdhSecret = this.mNode.getSharedECDHSecret();
        byte[] confirmationKey = SecureUtils.calculateK1(ecdhSecret, confirmationSalt, SecureUtils.PRCK);
        LOG.info("Confirmation key: " + MeshParserUtils.bytesToHex(confirmationKey, false));
        byte[] provisionerRandom = SecureUtils.generateRandomNumber();
        this.mNode.setProvisionerRandom(provisionerRandom);
        LOG.info("Provisioner random: " + MeshParserUtils.bytesToHex(provisionerRandom, false));
        byte[] authenticationValue = this.generateAuthenticationValue();
        this.mNode.setAuthenticationValue(authenticationValue);
        LOG.info("Authentication value: " + MeshParserUtils.bytesToHex(authenticationValue, false));
        ByteBuffer buffer = ByteBuffer.allocate(provisionerRandom.length + 16);
        buffer.put(provisionerRandom);
        buffer.put(authenticationValue);
        byte[] confirmationData = buffer.array();
        byte[] confirmationValue = SecureUtils.calculateCMAC(confirmationData, confirmationKey);
        buffer = ByteBuffer.allocate(confirmationValue.length + 2);
        buffer.put(new byte[]{3, 5});
        buffer.put(confirmationValue);
        byte[] provisioningConfirmationPDU = buffer.array();
        LOG.info("Provisioning confirmation: " + MeshParserUtils.bytesToHex(provisioningConfirmationPDU, false));
        return provisioningConfirmationPDU;
    }

    private byte[] generateAuthenticationValue() {
        switch (this.mNode.authMethodUsed) {
            case NO_OOB_AUTHENTICATION: {
                return NO_OOB_AUTH;
            }
            case STATIC_OOB_AUTHENTICATION: {
                return MeshParserUtils.toByteArray(this.authentication);
            }
            case OUTPUT_OOB_AUTHENTICATION: {
                OutputOOBAction action = OutputOOBAction.fromValue(this.mNode.getAuthActionUsed());
                return OutputOOBAction.generateOutputOOBAuthenticationValue(action, this.authentication);
            }
            case INPUT_OOB_AUTHENTICATION: {
                InputOOBAction inputOOBAction = InputOOBAction.fromValue(this.mNode.getAuthActionUsed());
                return InputOOBAction.generateInputOOBAuthenticationValue(inputOOBAction, this.mNode.getInputAuthentication());
            }
        }
        return null;
    }

    private void parseProvisioneeConfirmation(byte[] provisioneeConfirmation) {
        ByteBuffer buffer = ByteBuffer.allocate(provisioneeConfirmation.length - 2);
        buffer.put(provisioneeConfirmation, 2, buffer.limit());
        this.mNode.setProvisioneeConfirmation(buffer.array());
    }
}

