/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.MeshProvisioningStatusCallbacks;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningCapabilities;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.ProvisioningState;
import org.openremote.agent.protocol.bluetooth.mesh.provisionerstates.UnprovisionedMeshNode;

public class ProvisioningCapabilitiesState
extends ProvisioningState {
    public static final Logger LOG = Logger.getLogger(ProvisioningCapabilitiesState.class.getName());
    private final UnprovisionedMeshNode mUnprovisionedMeshNode;
    private final MeshProvisioningStatusCallbacks mCallbacks;
    private ProvisioningCapabilities capabilities;

    public ProvisioningCapabilitiesState(UnprovisionedMeshNode unprovisionedMeshNode, MeshProvisioningStatusCallbacks callbacks) {
        this.mCallbacks = callbacks;
        this.mUnprovisionedMeshNode = unprovisionedMeshNode;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_CAPABILITIES;
    }

    public ProvisioningCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void executeSend() {
    }

    @Override
    public boolean parseData(byte[] data) {
        boolean flag = this.parseProvisioningCapabilities(data);
        this.mUnprovisionedMeshNode.setProvisioningCapabilitiesPdu(data);
        this.mUnprovisionedMeshNode.setProvisioningCapabilities(this.capabilities);
        this.mCallbacks.onProvisioningStateChanged(this.mUnprovisionedMeshNode, ProvisioningState.States.PROVISIONING_CAPABILITIES, data);
        return flag;
    }

    private boolean parseProvisioningCapabilities(byte[] provisioningCapabilities) {
        this.capabilities = new ProvisioningCapabilities(provisioningCapabilities);
        return true;
    }
}

