/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.provisionerstates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.utils.AlgorithmType;
import org.openremote.agent.protocol.bluetooth.mesh.utils.AuthenticationOOBMethods;
import org.openremote.agent.protocol.bluetooth.mesh.utils.InputOOBAction;
import org.openremote.agent.protocol.bluetooth.mesh.utils.OutputOOBAction;

public class ProvisioningCapabilities {
    private static final int PUBLIC_KEY_INFORMATION_AVAILABLE = 1;
    private static final int STATIC_OOB_INFO_AVAILABLE = 1;
    private static final Logger LOG = Logger.getLogger(ProvisioningCapabilities.class.getName());
    private byte numberOfElements;
    private short rawAlgorithm;
    private List<AlgorithmType> supportedAlgorithmTypes;
    private byte rawPublicKeyType;
    private boolean publicKeyInformationAvailable;
    private byte rawStaticOOBType;
    private boolean staticOOBInformationAvailable;
    private byte outputOOBSize;
    private short rawOutputOOBAction;
    private List<OutputOOBAction> supportedOutputOOBActions;
    private byte inputOOBSize;
    private short rawInputOOBAction;
    private List<InputOOBAction> supportedInputOOBActions;
    private AuthenticationOOBMethods supportedOOBMethods;
    private final List<AuthenticationOOBMethods> availableOOBTypes = new ArrayList<AuthenticationOOBMethods>();

    ProvisioningCapabilities(byte[] capabilities) {
        ArrayList<InputOOBAction> arrayList;
        short inputOOBAction;
        byte inputOOBSize;
        ArrayList<OutputOOBAction> arrayList2;
        short outputOOBAction;
        byte outputOOBSize;
        short algorithm;
        byte numberOfElements;
        if (capabilities[2] == 0) {
            throw new IllegalArgumentException("Number of elements cannot be zero");
        }
        this.numberOfElements = numberOfElements = capabilities[2];
        LOG.info("Number of elements: " + numberOfElements);
        this.rawAlgorithm = algorithm = (short)((capabilities[3] & 0xFF) << 8 | capabilities[4] & 0xFF);
        this.supportedAlgorithmTypes = AlgorithmType.getAlgorithmTypeFromBitMask(algorithm);
        this.rawPublicKeyType = capabilities[5];
        this.publicKeyInformationAvailable = this.rawPublicKeyType == 1;
        LOG.info("Public key information available: " + this.publicKeyInformationAvailable);
        this.rawStaticOOBType = capabilities[6];
        this.staticOOBInformationAvailable = this.rawStaticOOBType == 1;
        LOG.info("Static OOB information available: : " + this.staticOOBInformationAvailable);
        this.outputOOBSize = outputOOBSize = capabilities[7];
        LOG.info("Output OOB size: " + outputOOBSize);
        this.rawOutputOOBAction = outputOOBAction = (short)((capabilities[8] & 0xFF) << 8 | capabilities[9] & 0xFF);
        if (outputOOBSize == 0) {
            ArrayList<OutputOOBAction> arrayList3;
            arrayList2 = arrayList3;
        } else {
            arrayList2 = OutputOOBAction.parseOutputActionsFromBitMask(outputOOBAction);
        }
        this.supportedOutputOOBActions = arrayList2;
        this.inputOOBSize = inputOOBSize = capabilities[10];
        LOG.info("Input OOB size: " + inputOOBSize);
        this.rawInputOOBAction = inputOOBAction = (short)((capabilities[11] & 0xFF) << 8 | capabilities[12] & 0xFF);
        if (inputOOBSize == 0) {
            ArrayList<InputOOBAction> arrayList4;
            arrayList = arrayList4;
            super();
        } else {
            arrayList = InputOOBAction.parseInputActionsFromBitMask(inputOOBAction);
        }
        this.supportedInputOOBActions = arrayList;
        this.generateAvailableOOBTypes();
    }

    private void generateAvailableOOBTypes() {
        this.availableOOBTypes.clear();
        this.availableOOBTypes.add(AuthenticationOOBMethods.NO_OOB_AUTHENTICATION);
        if (this.isStaticOOBInformationAvailable()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.STATIC_OOB_AUTHENTICATION);
        }
        if (!this.supportedOutputOOBActions.isEmpty()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.OUTPUT_OOB_AUTHENTICATION);
        }
        if (!this.supportedInputOOBActions.isEmpty()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.INPUT_OOB_AUTHENTICATION);
        }
    }

    public byte getNumberOfElements() {
        return this.numberOfElements;
    }

    void setNumberOfElements(byte numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public short getRawAlgorithm() {
        return this.rawAlgorithm;
    }

    void setRawAlgorithm(short algorithm) {
        this.rawAlgorithm = algorithm;
    }

    public List<AlgorithmType> getSupportedAlgorithmTypes() {
        return Collections.unmodifiableList(this.supportedAlgorithmTypes);
    }

    public byte getRawPublicKeyType() {
        return this.rawPublicKeyType;
    }

    void setRawPublicKeyType(byte rawPublicKeyType) {
        this.rawPublicKeyType = rawPublicKeyType;
    }

    public boolean isPublicKeyInformationAvailable() {
        return this.publicKeyInformationAvailable;
    }

    public byte getRawStaticOOBType() {
        return this.rawStaticOOBType;
    }

    void setRawStaticOOBType(byte rawStaticOOBType) {
        this.rawStaticOOBType = rawStaticOOBType;
    }

    public boolean isStaticOOBInformationAvailable() {
        return this.staticOOBInformationAvailable;
    }

    public byte getOutputOOBSize() {
        return this.outputOOBSize;
    }

    void setOutputOOBSize(byte outputOOBSize) {
        this.outputOOBSize = outputOOBSize;
    }

    public short getRawOutputOOBAction() {
        return this.rawOutputOOBAction;
    }

    void setRawOutputOOBAction(short rawOutputOOBAction) {
        this.rawOutputOOBAction = rawOutputOOBAction;
    }

    public List<OutputOOBAction> getSupportedOutputOOBActions() {
        return Collections.unmodifiableList(this.supportedOutputOOBActions);
    }

    public byte getInputOOBSize() {
        return this.inputOOBSize;
    }

    void setInputOOBSize(byte inputOOBSize) {
        this.inputOOBSize = inputOOBSize;
    }

    public short getRawInputOOBAction() {
        return this.rawInputOOBAction;
    }

    void setRawInputOOBAction(short rawInputOOBAction) {
        this.rawInputOOBAction = rawInputOOBAction;
    }

    public List<InputOOBAction> getSupportedInputOOBActions() {
        return Collections.unmodifiableList(this.supportedInputOOBActions);
    }

    public List<AuthenticationOOBMethods> getAvailableOOBTypes() {
        return Collections.unmodifiableList(this.availableOOBTypes);
    }
}

