/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.models;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.utils.CompanyIdentifiers;

public class VendorModel
extends MeshModel {
    public static final Logger LOG = Logger.getLogger(VendorModel.class.getName());
    private final short companyIdentifier;
    private final String companyName;

    public VendorModel(int modelIdentifier) {
        super(modelIdentifier);
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(modelIdentifier);
        this.companyIdentifier = buffer.getShort(0);
        this.companyName = CompanyIdentifiers.getCompanyName(this.companyIdentifier);
        LOG.info("Company name: " + this.companyName);
    }

    @Override
    public int getModelId() {
        return this.mModelId;
    }

    @Override
    public String getModelName() {
        return "Vendor Model";
    }

    public int getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    public String getCompanyName() {
        return this.companyName;
    }
}

