/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.models;

import org.openremote.agent.protocol.bluetooth.mesh.models.ConfigurationClientModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.ConfigurationServerModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.GenericOnOffClientModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.GenericOnOffServerModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.SigModel;
import org.openremote.agent.protocol.bluetooth.mesh.models.UnknownModel;

public class SigModelParser {
    private static final String TAG = SigModelParser.class.getSimpleName();
    public static final short CONFIGURATION_SERVER = 0;
    public static final short CONFIGURATION_CLIENT = 1;
    private static final short HEALTH_SERVER_MODEL = 2;
    private static final short HEALTH_CLIENT_MODEL = 3;
    public static final short GENERIC_ON_OFF_SERVER = 4096;
    public static final short GENERIC_ON_OFF_CLIENT = 4097;
    public static final short GENERIC_LEVEL_SERVER = 4098;
    public static final short GENERIC_LEVEL_CLIENT = 4099;
    private static final short GENERIC_DEFAULT_TRANSITION_TIME_SERVER = 4100;
    private static final short GENERIC_DEFAULT_TRANSITION_TIME_CLIENT = 4101;
    private static final short GENERIC_POWER_ON_OFF_SERVER = 4102;
    private static final short GENERIC_POWER_ON_OFF_SETUP_SERVER = 4103;
    private static final short GENERIC_POWER_ON_OFF_CLIENT = 4104;
    private static final short GENERIC_POWER_LEVEL_SERVER = 4105;
    private static final short GENERIC_POWER_LEVEL_SETUP_SERVER = 4106;
    private static final short GENERIC_POWER_LEVEL_CLIENT = 4107;
    private static final short GENERIC_BATTERY_SERVER = 4108;
    private static final short GENERIC_BATTERY_CLIENT = 4109;
    private static final short GENERIC_LOCATION_SERVER = 4110;
    private static final short GENERIC_LOCATION_SETUP_SERVER = 4111;
    private static final short GENERIC_LOCATION_CLIENT = 4112;
    private static final short GENERIC_ADMIN_PROPERTY_SERVER = 4113;
    private static final short GENERIC_MANUFACTURER_PROPERTY_SERVER = 4114;
    private static final short GENERIC_USER_PROPERTY_SERVER = 4115;
    private static final short GENERIC_CLIENT_PROPERTY_SERVER = 4116;
    private static final short GENERIC_PROPERTY_CLIENT = 4117;
    private static final short SENSOR_SERVER = 4352;
    private static final short SENSOR_SETUP_SERVER = 4353;
    private static final short SENSOR_CLIENT = 4354;
    private static final short TIME_SERVER = 4608;
    private static final short TIME_SETUP_SERVER = 4609;
    private static final short TIME_CLIENT = 4610;
    public static final short SCENE_SERVER = 4611;
    public static final short SCENE_SETUP_SERVER = 4612;
    private static final short SCENE_CLIENT = 4613;
    private static final short SCHEDULER_SERVER = 4614;
    private static final short SCHEDULER_SETUP_SERVER = 4615;
    private static final short SCHEDULER_CLIENT = 4616;
    private static final short LIGHT_LIGHTNESS_SERVER = 4864;
    private static final short LIGHT_LIGHTNESS_SETUP_SERVER = 4865;
    private static final short LIGHT_LIGHTNESS_CLIENT = 4866;
    private static final short LIGHT_CTL_SERVER = 4867;
    private static final short LIGHT_CTL_SETUP_SERVER = 4868;
    private static final short LIGHT_CTL_CLIENT = 4869;
    private static final short LIGHT_CTL_TEMPERATURE_SERVER = 4870;
    private static final short LIGHT_HSL_SERVER = 4871;
    private static final short LIGHT_HSL_SETUP_SERVER = 4872;
    private static final short LIGHT_HSL_CLIENT = 4873;
    private static final short LIGHT_HSL_HUE_SERVER = 4874;
    private static final short LIGHT_HSL_SATURATION_SERVER = 4875;
    private static final short LIGHT_XYL_SERVER = 4876;
    private static final short LIGHT_XYL_SETUP_SERVER = 4877;
    private static final short LIGHT_XYL_CLIENT = 4878;
    private static final short LIGHT_LC_SERVER = 4879;
    private static final short LIGHT_LC_SETUP_SERVER = 4880;
    private static final short LIGHT_LC_CLIENT = 4881;

    public static SigModel getSigModel(int modelId) {
        switch (modelId) {
            case 0: {
                return new ConfigurationServerModel(modelId);
            }
            case 1: {
                return new ConfigurationClientModel(modelId);
            }
            case 4096: {
                return new GenericOnOffServerModel(modelId);
            }
            case 4097: {
                return new GenericOnOffClientModel(modelId);
            }
        }
        return new UnknownModel(modelId);
    }
}

