/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh.control;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.control.TransportControlMessage;

public class BlockAcknowledgementMessage
extends TransportControlMessage {
    public static final Logger LOG = Logger.getLogger(BlockAcknowledgementMessage.class.getName());

    public BlockAcknowledgementMessage(byte[] acknowledgementPayload) {
    }

    public static Integer calculateBlockAcknowledgement(Integer blockAck, int segO) {
        int ack = 0;
        if (blockAck == null) {
            LOG.info("Block ack value: " + Integer.toString(ack |= 1 << segO, 16));
            return ack;
        }
        ack = blockAck;
        LOG.info("Block ack value: " + Integer.toString(ack |= 1 << segO, 16));
        return ack;
    }

    public static int calculateBlockAcknowledgement(int segN) {
        int segmentCount = segN + 1;
        int ack = 0;
        for (int i = 0; i < segmentCount; ++i) {
            ack |= 1 << i;
        }
        return ack;
    }

    @Override
    public TransportControlMessage.TransportControlMessageState getState() {
        return TransportControlMessage.TransportControlMessageState.LOWER_TRANSPORT_BLOCK_ACKNOWLEDGEMENT;
    }

    public static ArrayList<Integer> getSegmentsToBeRetransmitted(byte[] blockAcknowledgement, int segmentCount) {
        ArrayList<Integer> retransmitSegments = new ArrayList<Integer>();
        int blockAck = ByteBuffer.wrap(blockAcknowledgement).order(ByteOrder.BIG_ENDIAN).getInt();
        for (int i = 0; i < segmentCount; ++i) {
            int bit = blockAck >> i & 1;
            if (bit == 1) {
                LOG.info("Segment " + i + " of " + (segmentCount - 1) + " received by peer");
                continue;
            }
            retransmitSegments.add(i);
            LOG.info("Segment " + i + " of " + (segmentCount - 1) + " not received by peer");
        }
        return retransmitSegments;
    }

    public static boolean hasAllSegmentsBeenReceived(Integer blockAcknowledgement, int segN) {
        if (blockAcknowledgement == null) {
            return false;
        }
        LOG.info("Block ack: " + blockAcknowledgement);
        int blockAck = blockAcknowledgement;
        int setBitCount = 0;
        for (int i = 0; i < segN; ++i) {
            int bit = blockAck >> i & 1;
            if (bit != 1) continue;
            ++setBitCount;
        }
        LOG.info("bit count: " + setBitCount);
        return setBitCount == segN + 1;
    }
}

