/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshElement;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.model.syslog.SyslogCategory;

public abstract class ShadowMeshModel {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)ShadowMeshModel.class.getName());
    protected final ShadowMeshElement element;
    protected final BluetoothMeshNetwork meshNetwork;
    protected int appKeyIndex;
    private final List<Consumer<Object>> sensorValueConsumers = new ArrayList<Consumer<Object>>();
    protected final ScheduledExecutorService executorService;

    public ShadowMeshModel(ScheduledExecutorService executorService, BluetoothMeshNetwork network, ShadowMeshElement element, int appKeyIndex) {
        this.executorService = executorService;
        this.meshNetwork = network;
        this.element = element;
        this.appKeyIndex = appKeyIndex;
    }

    public synchronized void addSensorValueConsumer(Consumer<Object> consumer) {
        if (consumer != null && !this.sensorValueConsumers.contains(consumer)) {
            this.sensorValueConsumers.add(consumer);
        }
    }

    public synchronized void removeSensorValueConsumer(Consumer<Object> consumer) {
        if (consumer != null && this.sensorValueConsumers.contains(consumer)) {
            this.sensorValueConsumers.remove(consumer);
        }
    }

    public synchronized void setAppKeyIndex(int appKeyIndex) {
        this.appKeyIndex = appKeyIndex;
    }

    public synchronized void sendSetCommand(Object value) {
        ApplicationKey key = this.meshNetwork.getApplicationKey(this.appKeyIndex);
        if (key != null) {
            MeshMessage meshMessage = this.createSetMeshMessage(key, value);
            if (meshMessage != null) {
                this.meshNetwork.getMeshManagerApi().createMeshPdu(this.element.getAddress(), meshMessage);
            }
        } else {
            LOG.severe("Failed to send mesh model '" + this.getModelName() + "' command value '" + value + "' because couldn't find application key for index '" + this.appKeyIndex + "', address: '" + this.element.getAddress());
        }
    }

    public synchronized void sendGetCommand() {
        ApplicationKey key = this.meshNetwork.getApplicationKey(this.appKeyIndex);
        if (key != null) {
            MeshMessage meshMessage = this.createGetMeshMessage(key);
            if (meshMessage != null) {
                this.meshNetwork.getMeshManagerApi().createMeshPdu(this.element.getAddress(), meshMessage);
            } else {
                LOG.severe("Failed to send mesh model '" + this.getModelName() + "' get status command because couldn't find application key for index '" + this.appKeyIndex + "'");
            }
        }
    }

    protected void executeSensorValueConsumers(Object value) {
        this.executorService.execute(() -> {
            ShadowMeshModel shadowMeshModel = this;
            synchronized (shadowMeshModel) {
                for (Consumer<Object> consumer : this.sensorValueConsumers) {
                    consumer.accept(value);
                }
            }
        });
    }

    public abstract void onMeshMessageReceived(MeshMessage var1);

    protected abstract MeshMessage createSetMeshMessage(ApplicationKey var1, Object var2);

    protected abstract MeshMessage createGetMeshMessage(ApplicationKey var1);

    protected abstract String getModelName();

    protected abstract int getModelId();
}

