/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowGenericOnOffModel;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.model.syslog.SyslogCategory;

public class ShadowMeshElement {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)ShadowMeshElement.class.getName());
    private final ScheduledExecutorService executorService;
    private final BluetoothMeshNetwork meshNetwork;
    private final int address;
    private final Map<Integer, ShadowMeshModel> modelMap = new HashMap<Integer, ShadowMeshModel>();

    public ShadowMeshElement(ScheduledExecutorService executorService, BluetoothMeshNetwork network, int address) {
        this.executorService = executorService;
        this.meshNetwork = network;
        this.address = address;
    }

    public synchronized void addShadowModel(int modelId, int appKeyIndex) {
        ShadowMeshModel model = this.modelMap.get(modelId);
        if (model != null) {
            model.setAppKeyIndex(appKeyIndex);
        } else {
            model = this.createShadowModel(modelId, appKeyIndex);
            if (model != null) {
                this.modelMap.put(modelId, model);
            }
        }
    }

    public synchronized void onMeshMessageReceived(MeshMessage meshMessage) {
        for (ShadowMeshModel model : this.modelMap.values()) {
            model.onMeshMessageReceived(meshMessage);
        }
    }

    public synchronized int getAddress() {
        return this.address;
    }

    public synchronized List<ShadowMeshModel> getMeshModels() {
        return new ArrayList<ShadowMeshModel>(this.modelMap.values());
    }

    public synchronized ShadowMeshModel searchShadowModel(int modelId) {
        return this.modelMap.get(modelId);
    }

    private ShadowMeshModel createShadowModel(int modelId, int appKeyIndex) {
        ShadowGenericOnOffModel model = null;
        if (4096 == modelId) {
            model = new ShadowGenericOnOffModel(this.executorService, this.meshNetwork, this, appKeyIndex);
        }
        return model;
    }
}

