/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.ApplicationKey;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshNetwork;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshElement;
import org.openremote.agent.protocol.bluetooth.mesh.ShadowMeshModel;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericOnOffGet;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericOnOffSetUnacknowledged;
import org.openremote.agent.protocol.bluetooth.mesh.transport.GenericOnOffStatus;
import org.openremote.agent.protocol.bluetooth.mesh.transport.MeshMessage;
import org.openremote.model.syslog.SyslogCategory;

public class ShadowGenericOnOffModel
extends ShadowMeshModel {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)ShadowGenericOnOffModel.class.getName());

    public ShadowGenericOnOffModel(ScheduledExecutorService executorService, BluetoothMeshNetwork network, ShadowMeshElement element, int appKeyIndex) {
        super(executorService, network, element, appKeyIndex);
    }

    @Override
    public synchronized void onMeshMessageReceived(MeshMessage meshMessage) {
        if (meshMessage.getOpCode() == 33284 && meshMessage instanceof GenericOnOffStatus) {
            GenericOnOffStatus status = (GenericOnOffStatus)meshMessage;
            Boolean isOn = status.getPresentState();
            LOG.info("Received model status update: [model=GenericOnOffServer, address=" + this.element.getAddress() + ", state=" + (isOn != false ? "ON" : "OFF") + "]");
            this.executeSensorValueConsumers(isOn);
        }
    }

    @Override
    protected MeshMessage createSetMeshMessage(ApplicationKey applicationKey, Object value) {
        GenericOnOffSetUnacknowledged meshMessage = null;
        int tid = new Random().nextInt();
        Boolean onOffValue = this.toBoolean(value);
        if (onOffValue != null) {
            meshMessage = new GenericOnOffSetUnacknowledged(applicationKey, onOffValue, tid);
        }
        return meshMessage;
    }

    @Override
    protected MeshMessage createGetMeshMessage(ApplicationKey applicationKey) {
        return new GenericOnOffGet(applicationKey);
    }

    @Override
    protected String getModelName() {
        return "Generic On Off";
    }

    @Override
    protected int getModelId() {
        return 4096;
    }

    private Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        Boolean onOffValue = null;
        if (value instanceof Boolean) {
            onOffValue = (Boolean)value;
        } else if (value instanceof Integer) {
            onOffValue = (Integer)value != 0;
        } else if (value instanceof Double) {
            onOffValue = (Double)value != 0.0;
        } else if (value instanceof String) {
            onOffValue = this.fromStringToBoolean((String)value);
        }
        return onOffValue;
    }

    private Boolean fromStringToBoolean(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        Boolean boolValue = null;
        if ((stringValue = stringValue.trim()).equalsIgnoreCase("false") || stringValue.equalsIgnoreCase("off") || stringValue.equalsIgnoreCase("0")) {
            boolValue = false;
        } else if (stringValue.equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("on") || stringValue.equalsIgnoreCase("1")) {
            boolValue = true;
        }
        return boolValue;
    }
}

