/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openremote.agent.protocol.bluetooth.mesh.NetworkKey;
import org.openremote.agent.protocol.bluetooth.mesh.utils.MeshParserUtils;
import org.openremote.model.syslog.SyslogCategory;

public class SequenceNumberPersistencyManager {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)SequenceNumberPersistencyManager.class.getName());
    public static String XML_TAG_SEQUENCE_NUMBER_LIST = "SequenceNumbers";
    public static String XML_TAG_SEQUENCE_NUMBER_ITEM = "SequenceNumberItem";
    public static String XML_TAG_NETWORK_KEY = "NetworkKey";
    public static String XML_TAG_ADDRESS = "UnicastAddress";
    public static String XML_TAG_SEQUENCE_NUMBER = "SequenceNumber";
    private final Map<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
    private final URI filePath = new File("/btmesh/sequencenumber.xml").toURI();

    public synchronized void save(NetworkKey networkKey, int unicastAddress, int sequenceNumber) {
        String key = MeshParserUtils.bytesToHex(networkKey.key, false);
        String address = String.format("%04X", unicastAddress);
        LOG.info("Save sequence number: [sourceAddress=" + address + ", sequenceNumber=" + sequenceNumber + "]");
        if (!this.map.containsKey(key)) {
            this.map.put(key, new HashMap());
        }
        Map<String, Integer> addressToNumberMap = this.map.get(key);
        addressToNumberMap.put(address, sequenceNumber);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        Document doc = new Document();
        Element root = new Element(XML_TAG_SEQUENCE_NUMBER_LIST);
        doc.addContent((Content)root);
        for (Map.Entry<String, Map<String, Integer>> mapEntry : this.map.entrySet()) {
            String key = mapEntry.getKey();
            for (Map.Entry<String, Integer> supMapEntry : mapEntry.getValue().entrySet()) {
                String address = supMapEntry.getKey();
                Integer number = supMapEntry.getValue();
                Element itemElement = new Element(XML_TAG_SEQUENCE_NUMBER_ITEM);
                Element keyElement = new Element(XML_TAG_NETWORK_KEY);
                keyElement.setText(key);
                Element addressElement = new Element(XML_TAG_ADDRESS);
                addressElement.setText(address);
                Element numberElement = new Element(XML_TAG_SEQUENCE_NUMBER);
                numberElement.setText(Integer.toString(number));
                itemElement.addContent((Content)keyElement);
                itemElement.addContent((Content)addressElement);
                itemElement.addContent((Content)numberElement);
                root.addContent((Content)itemElement);
            }
        }
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        OutputStreamWriter writer = null;
        File file = null;
        try {
            file = new File(this.filePath);
            writer = new FileWriter(new File(this.filePath));
            outputter.output(doc, (Writer)writer);
            writer.flush();
        }
        catch (IOException e) {
            LOG.severe("Failed to save sequence number file: '" + file.getPath() + "' because: " + e.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.severe("Failed to close sequence number file: '" + file.getPath() + "' because: " + e.getMessage());
                }
            }
        }
    }

    public synchronized void load() {
        if (!this.fileExists()) {
            return;
        }
        File file = new File(this.filePath);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(file);
        }
        catch (JDOMException e) {
            LOG.severe("Failed to load sequence number file: '" + file.getPath() + "' because: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            LOG.severe("Failed to load sequence number file: '" + file.getPath() + "' because: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        this.map.clear();
        Element root = doc.getRootElement();
        List itemElements = root.getChildren(XML_TAG_SEQUENCE_NUMBER_ITEM);
        for (Element itemElement : itemElements) {
            Element keyElement = itemElement.getChild(XML_TAG_NETWORK_KEY);
            Element addressElement = itemElement.getChild(XML_TAG_ADDRESS);
            Element numberElement = itemElement.getChild(XML_TAG_SEQUENCE_NUMBER);
            if (keyElement == null || addressElement == null | numberElement == null) continue;
            String key = keyElement.getText();
            String address = addressElement.getText();
            String number = numberElement.getText();
            if (!this.map.containsKey(key)) {
                this.map.put(key, new HashMap());
            }
            try {
                this.map.get(key).put(address, Integer.valueOf(number));
            }
            catch (NumberFormatException e) {
                LOG.severe("Error while loading sequence number file: '" + file.getPath() + "' because: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public synchronized Integer getSequenceNumber(NetworkKey networkKey, int unicastAddress) {
        Integer number = null;
        String key = MeshParserUtils.bytesToHex(networkKey.key, false);
        String address = String.format("%04X", unicastAddress);
        if (this.map.containsKey(key)) {
            number = this.map.get(key).get(address);
        }
        return number;
    }

    private boolean fileExists() {
        return new File(this.filePath).exists();
    }
}

