/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothPeripheral;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxy;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxySendDataCallback;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.SendDataCommand;
import org.openremote.model.syslog.SyslogCategory;

public class SendSingleDataSegmentCommand
implements SendDataCommand {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)SendSingleDataSegmentCommand.class.getName());
    private final BluetoothGattCharacteristic dataInCharacteristic;
    protected final BluetoothMeshProxySendDataCallback callback;
    private final byte[] data;
    protected final ScheduledExecutorService executorService;
    private final BluetoothMeshProxy meshProxy;
    private final MainThreadManager commandSerializer;
    private volatile boolean isWaitForCallback = false;
    private final BlockingQueue<BluetoothCommandStatus> resultQueue = new ArrayBlockingQueue<BluetoothCommandStatus>(1);

    public SendSingleDataSegmentCommand(BluetoothMeshProxy proxy, MainThreadManager commandSerializer, ScheduledExecutorService executorService, BluetoothGattCharacteristic characteristic, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        this.meshProxy = proxy;
        this.commandSerializer = commandSerializer;
        this.executorService = executorService;
        this.dataInCharacteristic = characteristic;
        this.data = data;
        this.callback = callback;
    }

    @Override
    public boolean sendData() {
        boolean isSuccess = false;
        if (this.isWaitForCallback) {
            return false;
        }
        this.isWaitForCallback = true;
        LOG.info("Sending '" + this.data.length + "' bytes to mesh proxy: [data=" + this.dataAsHexString(this.data) + "]");
        Runnable runnable = () -> this.dataInCharacteristic.getService().getPeripheral().writeCharacteristic(this.dataInCharacteristic, this.data, BluetoothGattCharacteristic.WriteType.WITHOUT_RESPONSE);
        this.commandSerializer.enqueue(runnable);
        try {
            BluetoothCommandStatus status = this.resultQueue.poll(5000L, TimeUnit.MILLISECONDS);
            if (status != null) {
                boolean bl = isSuccess = status == BluetoothCommandStatus.COMMAND_SUCCESS;
                if (isSuccess) {
                    LOG.info("Successfully sent '" + this.data.length + "' bytes to mesh proxy: [data=" + this.dataAsHexString(this.data) + "]");
                } else {
                    LOG.warning("Failed to send '" + this.data.length + "' bytes to mesh proxy: [data=" + this.dataAsHexString(this.data) + ", status=" + status + "]");
                }
            } else {
                LOG.severe("Failed to send '" + this.data.length + "' bytes to mesh proxy [data=" + this.dataAsHexString(this.data) + "] because of confirmation timeout");
                isSuccess = false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (this.callback != null) {
            boolean callbackResult = isSuccess;
            this.executorService.execute(() -> this.callback.onDataSent(this.meshProxy, this.data, callbackResult));
        }
        return isSuccess;
    }

    @Override
    public void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        if (this.dataInCharacteristic.getService().getPeripheral().getAddress().equals(peripheral.getAddress()) && this.dataInCharacteristic.getService().getUuid().equals(characteristic.getService().getUuid()) && this.dataInCharacteristic.getUuid().equals(characteristic.getUuid()) && this.resultQueue.isEmpty()) {
            try {
                this.resultQueue.put(status);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private String dataAsHexString(byte[] data) {
        if (data == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            builder.append(String.format("0x%02X%s", data[i] & 0xFF, i == data.length - 1 ? "" : ", "));
        }
        return builder.toString();
    }
}

