/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.agent.protocol.bluetooth.mesh;

import com.welie.blessed.BluetoothCommandStatus;
import com.welie.blessed.BluetoothGattCharacteristic;
import com.welie.blessed.BluetoothPeripheral;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxy;
import org.openremote.agent.protocol.bluetooth.mesh.BluetoothMeshProxySendDataCallback;
import org.openremote.agent.protocol.bluetooth.mesh.MainThreadManager;
import org.openremote.agent.protocol.bluetooth.mesh.SendDataCommand;
import org.openremote.agent.protocol.bluetooth.mesh.SendSingleDataSegmentCommand;
import org.openremote.model.syslog.SyslogCategory;

public class SendMultiDataSegmentCommand
implements SendDataCommand {
    public static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, (String)SendMultiDataSegmentCommand.class.getName());
    private final BluetoothMeshProxy meshProxy;
    private final MainThreadManager commandSerializer;
    private final BluetoothGattCharacteristic dataInCharacteristic;
    private final BluetoothMeshProxySendDataCallback callback;
    private final byte[] data;
    private final ScheduledExecutorService executorService;
    private final List<SendSingleDataSegmentCommand> commands;
    private volatile SendSingleDataSegmentCommand currentCommand;

    public SendMultiDataSegmentCommand(BluetoothMeshProxy proxy, MainThreadManager commandSerializer, int mtuSize, ScheduledExecutorService executorService, BluetoothGattCharacteristic characteristic, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        this.meshProxy = proxy;
        this.commandSerializer = commandSerializer;
        this.dataInCharacteristic = characteristic;
        this.callback = callback;
        this.executorService = executorService;
        this.data = data;
        this.commands = this.createCommands(mtuSize, executorService, characteristic, data, callback);
    }

    @Override
    public boolean sendData() {
        boolean isSuccess = true;
        for (SendSingleDataSegmentCommand curCommand : this.commands) {
            this.setCurrentCommand(curCommand);
            if (curCommand.sendData()) continue;
            isSuccess = false;
            break;
        }
        if (this.callback != null) {
            boolean callbackResult = isSuccess;
            this.executorService.execute(() -> this.callback.onDataSent(this.meshProxy, this.data, callbackResult));
        }
        return isSuccess;
    }

    @Override
    public synchronized void onCharacteristicWrite(BluetoothPeripheral peripheral, byte[] value, BluetoothGattCharacteristic characteristic, BluetoothCommandStatus status) {
        if (this.currentCommand != null) {
            this.currentCommand.onCharacteristicWrite(peripheral, value, characteristic, status);
        }
    }

    private List<SendSingleDataSegmentCommand> createCommands(int mtuSize, ScheduledExecutorService executorService, BluetoothGattCharacteristic characteristic, byte[] data, BluetoothMeshProxySendDataCallback callback) {
        int numOfSegments = data.length / mtuSize + (data.length % mtuSize > 0 ? 1 : 0);
        ArrayList<SendSingleDataSegmentCommand> commandList = new ArrayList<SendSingleDataSegmentCommand>(numOfSegments);
        for (int i = 0; i < numOfSegments; ++i) {
            int length = Math.min(data.length - mtuSize * i, mtuSize);
            byte[] segmentData = new byte[length];
            System.arraycopy(data, mtuSize * i, segmentData, 0, length);
            SendSingleDataSegmentCommand cmd = new SendSingleDataSegmentCommand(this.meshProxy, this.commandSerializer, executorService, characteristic, segmentData, null);
            commandList.add(cmd);
        }
        return commandList;
    }

    private synchronized void setCurrentCommand(SendSingleDataSegmentCommand command) {
        this.currentCommand = command;
    }
}

